// Created by Cutter894
using System;
using System.Collections;
using Server.Items;
using Server.Targeting;
using Server.Misc;

namespace Server.Mobiles
{
	//[CorpseName( "a mimic corpse" )]
	public class MimicMelee : BaseCreature
	{

		[Constructable]
		public MimicMelee() : base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Name = "a mimic";
			Body = Utility.RandomList( 17, 28, 147, 54, 75, 1, 42, 752, 36, 59 );
			BaseSoundID = 0x45A;
                        Hue = 23065;

			SetStr( 296, 320 );
			SetDex( 71, 105 );
			SetInt( 56, 90 );

			SetHits( 158, 172 );   // Line 25

			SetDamage( 8, 35 );

			SetDamageType( ResistanceType.Physical, 100 );

			SetResistance( ResistanceType.Physical, 25, 30 );
			SetResistance( ResistanceType.Fire, 30, 45 );
			SetResistance( ResistanceType.Cold, 30, 45 );
			SetResistance( ResistanceType.Poison, 30, 45 );
			SetResistance( ResistanceType.Energy, 30, 45 );

			SetSkill( SkillName.Magery, 25.0, 55.0 );
			SetSkill( SkillName.MagicResist, 50.1, 75.0 );
			SetSkill( SkillName.Tactics, 55.1, 80.0 );
			SetSkill( SkillName.Wrestling, 50.1, 70.0 );

			Fame = 2500;
			Karma = -2500;

			VirtualArmor = 38;

			switch ( Utility.Random( 10 ) )
			{
				case 0: PackItem( new Katana() ); break;
				case 1: PackItem( new DoubleBladedStaff() ); break;
				case 2: PackItem( new Buckler() ); break;   // Line 50
				case 3: PackItem( new GoldRing() ); break;
				case 4: PackItem( new NorseHelm() ); break;
				case 5: PackItem( new RepeatingCrossbow() ); break;
			}

         PackItem( new Boots() );
                        
         if ( 0.2 > Utility.RandomDouble() )
				PackItem( new MimicShard() );
		}

		public override void GenerateLoot()
		{
			AddLoot( LootPack.Average, 2 );

		}

		public override bool AlwaysMurderer{ get{ return true; } }
      public override bool CanRummageCorpses{ get{ return false; } }
		public override int Meat{ get{ return 1; } }


		public MimicMelee( Serial serial ) : base( serial )
		{
		}
                 // Line 75
		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}
