using System;

namespace Server.Items
{
	public class MimicShard : Item, ICommodity
	{
        string ICommodity.Description
		{
			get
			{
				return String.Format( Amount == 1 ? "{0} mimic shard" : "{0} mimic shard", Amount );
			}
		}

		[Constructable]
		public MimicShard() : this( 1 )
		{
		}

		[Constructable]
		public MimicShard( int amount ) : base( 0x0DE2 )
		{
			Name = "Mimic Shard";
                        Stackable = true;
			Weight = 0.1;
			Amount = amount;
			Hue = 323;
		}

		public MimicShard( Serial serial ) : base( serial )
		{
		}

// 		public override Item Dupe( int amount )
// 		{
// 			return base.Dupe( new MimicShard( amount ), amount );
// 		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}
