using System;
using System.Collections.Generic;
using System.Collections;
using Server.Items;
using Server.Targeting;
// using Server.ContextMenus;
using Server.Misc;
using Server.Network;

namespace Server.Mobiles
{
	//[CorpseName("Corpse Of Scrollcrafter")]
	public class ScrollCrafter : BaseCreature
	{
		public virtual bool IsInvulnerable { get { return true; } }
		public override bool DisallowAllMoves { get { return true; } }
		
		[Constructable]
		public ScrollCrafter()
			: base(AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4)
		{
			Name = "Scroll Crafter";
			Body = 400;
			CantWalk = true;
			Hue = 33770;
			Blessed = true;

			//             AddItem( new ShortHair( Utility.RandomHairHue() ) );
			Utility.AssignRandomHair( this );
			AddItem(new Server.Items.FurCape(1150));
			AddItem(new Server.Items.Sandals(1530));
			AddItem( new LongPants( Utility.RandomNeutralHue() ) );

			Doublet doublet = new Doublet();
			doublet.Hue = 1530;
			doublet.Movable = false;
			AddItem(doublet);
		}

		public ScrollCrafter(Serial serial)
			: base(serial)
		{
		}

		// 	     public override void GetContextMenuEntries( Mobile from, List<ContextMenuEntry> list )
		//         {
		//             base.GetContextMenuEntries(from, list);
		//             list.Add(new ScrollCrafterEntry(from, this));
		//         }

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);
			writer.Write((int)0);
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);
			int version = reader.ReadInt();
		}

		//         public class ScrollCrafterEntry : ContextMenuEntry
		//         {
		//             private Mobile m_Mobile;
		//             private Mobile m_Giver;
		// 
		//             public ScrollCrafterEntry(Mobile from, Mobile giver)
		//                 : base(6146, 3)
		//             {
		//                 m_Mobile = from;
		//                 m_Giver = giver;
		//             }
		//         }

		public override bool HandlesOnSpeech(Mobile from)
		{
			base.HandlesOnSpeech(from);
			return true;
		}

		public override void OnSpeech(SpeechEventArgs e)
		{

			bool isMatch = false;

			Mobile from = e.Mobile;

			string keyword = "hi";
			string keyword2 = "ahoj";


			if ((keyword != null && e.Speech.ToLower().IndexOf(keyword.ToLower()) >= 0)
			    || (keyword2 != null && e.Speech.ToLower().IndexOf(keyword2.ToLower()) >= 0))
			{
				isMatch = true;

				if (!isMatch)
					return;

				SayTo( from, "Zdravim te! Pokud mas zajem, vymenim 20 tvych power scroll tokenu za 1 nahodny 120 power scroll na nevyrobni skilly." );
				SayTo( from, "Stejne tak vymenim tvuj PS za tokeny. Za kazdych 5 bodu sily PS ti dam 1 token." );
				e.Handled = true;
			}
			base.OnSpeech(e);
		}

		public override bool OnDragDrop(Mobile from, Item dropped)
		{
			Mobile m = from;
			PlayerMobile mobile = m as PlayerMobile;

			if (mobile != null)
			{
				//tokeny
				if ( dropped is PSToken )
				{
					if ( dropped.Amount == 20 )
					{
						dropped.Delete();
						//random PS
						PowerScroll ps = PowerScroll.CreateRandomNoCraft(20,20);
						from.AddToBackpack( ps );
						return true;
					}
					else
					{
						SayTo( from, "Dej mi presne 20 tokenu");
						return false;
					}
				}
				else if ( dropped is PowerScroll )
				{
					PowerScroll ps = (PowerScroll)dropped;
					if ( ps.Value == 105.0 )
					{
						dropped.Delete();
						from.AddToBackpack( new PSToken( 1 ) );
						return true;
					}
					if ( ps.Value == 110.0 )
					{
						dropped.Delete();
						from.AddToBackpack( new PSToken( 2 ) );
						return true;
					}
					if ( ps.Value == 115.0 )
					{
						dropped.Delete();
						from.AddToBackpack( new PSToken( 3 ) );
						return true;
					}
					if ( ps.Value == 120.0 )
					{
						dropped.Delete();
						from.AddToBackpack( new PSToken( 4 ) );
						return true;
					}
					return false;
				}
				else
				{
					SayTo( from, "Dej mi PS token nebo powerscroll.");
					return false;
				}
			}
			return false;
		}
	}
}



