using System;
using System.Collections;
using System.Collections.Generic;
using Server.Items;
using Server.ContextMenus;
using Server.Misc;
using Server.Network;

namespace Server.Mobiles
{
	//[CorpseName("a rat corpse")]
	public class ShardCleaner : BaseCreature
	{
		private DateTime m_NextPickup;
		private DateTime m_NextEmptying;

		[Constructable]
		public ShardCleaner() : base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.1, 0.2 )
		{
			Name = "a rat";
			Body = 238;
			BaseSoundID = 0xCC;
			Blessed = true;
			NameHue = 966;
			SetStr( 1000, 1010 );
			SetDex( 181, 295 );
			SetInt( 61, 75 );
			SetDamage( 13, 28 );
			VirtualArmor = 50;
			
			Container pack = Backpack;

			if ( pack != null )
				pack.Delete();

			pack = new StrongBackpack();
			pack.Movable = false;

			AddItem( pack );
		}

		Type[] exemptlist = new Type[]{ typeof(Gold), typeof(CechovniMince), typeof(Tokens) };

		public override void OnThink()
		{
			if ( DateTime.Now < m_NextPickup )
			{
				base.OnThink();
				return;
			}
			
			m_NextPickup = DateTime.Now + TimeSpan.FromSeconds( 2.5 + (2.5 * Utility.RandomDouble()) );

			if ( DateTime.Now > m_NextEmptying )
			{
				if ( this.Backpack != null )
				{
					List<Item> items = this.Backpack.Items;
					
					if ( items.Count > 0 )
					{
						for ( int x = items.Count - 1; x >= 0; --x )
						{
							if ( x >= items.Count )
								continue;
							
							if ( items[x] != null )
								items[x].Delete();
						}
					}
				}
				
				m_NextEmptying = DateTime.Now + TimeSpan.FromMinutes( 480.0 );
			}

			ArrayList Trash = new ArrayList();
			
			foreach ( Item item in this.GetItemsInRange( 2 ) )
			{
				if ( item.Movable && item.Decays && item.LootType != LootType.Blessed && item.BlessedFor == null && item.RootParentEntity == null && !(item is BaseAddon))
					Trash.Add(item);
			}
			
			bool TrashIt = true;
			
			for (int i = 0; i < Trash.Count; i++)
			{
				for (int j = 0; j < exemptlist.Length; j++)
				{
					if ( (Trash[i]).GetType() == exemptlist[j] )
						TrashIt = false;
				}
				
				if (TrashIt)
				{
					PackItem( (Item) Trash[i] );
					m_NextEmptying = DateTime.Now + TimeSpan.FromMinutes( 480.0 );
				}
				
				TrashIt = true;
			}
			
			base.OnThink();
		}

		public override void GetContextMenuEntries( Mobile from, List<ContextMenuEntry> list )
		{
			base.GetContextMenuEntries( from, list );

			if ( from.AccessLevel > AccessLevel.Player )
				PackAnimal.GetContextMenuEntries( this, from, list );
		}
		
		public override bool IsSnoop( Mobile from )
		{
			return false;
		}

		public ShardCleaner( Serial serial ) : base( serial ) { }
		public override void Serialize( GenericWriter writer ) { base.Serialize( writer ); writer.Write( (int) 0 ); }
		public override void Deserialize( GenericReader reader ) { base.Deserialize( reader ); int version = reader.ReadInt(); }
	}
}
