//Modifications for the Mobile Abilities Package are done and created by Peoharen and morgion.
using System;
using Server;
using Server.Items;

namespace Server.Mobiles
{
	//[CorpseName( "a spider king corpse" )]
	public class SpiderKing : BaseCreature
	{
		public override WeaponAbility GetWeaponAbility()
		{
			return WeaponAbility.ConcussionBlow;
		}

		[Constructable]
		public SpiderKing() :  base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Body = 28;
			Name = "Spider King";
			Hue = 1767;

			BaseSoundID = 0x388;

			SetStr( 505, 700 );
			SetDex( 202, 300 );
			SetInt( 402, 600 );

			SetHits( 1200, 1500 );
			SetStam( 305, 600 );

			SetDamage( 20, 35 );

			SetDamageType( ResistanceType.Physical, 20 );
			SetDamageType( ResistanceType.Poison, 80 );

			SetResistance( ResistanceType.Physical, 75, 80 );
			SetResistance( ResistanceType.Fire, 60, 70 );
			SetResistance( ResistanceType.Cold, 60, 70 );
			SetResistance( ResistanceType.Poison, 100 );
			SetResistance( ResistanceType.Energy, 60, 70 );

			SetSkill( SkillName.MagicResist, 90.7, 140.0 );
			SetSkill( SkillName.Tactics, 97.6, 100.0 );
			SetSkill( SkillName.Wrestling, 97.6, 100.0 );
			SetSkill( SkillName.Anatomy, 97.6, 100.0 );
			
			Fame = 20000;
			Karma = -9500;

			VirtualArmor = 80;
			Tamable = false;
			PackItem( new SpidersSilk( 50 ) );
			PackItem( new GreaterPoisonPotion() );
		}

		public override void GenerateLoot()
		{
			AddLoot( LootPack.UltraRich );
			AddLoot( LootPack.Rich, 2 );
		}

		public override Poison PoisonImmune{ get{ return Poison.Lethal; } }
		public override Poison HitPoison{ get{ return Poison.Deadly; } }
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		public override bool Unprovokable{ get{ return true; } }

		public static void WebAttack( Mobile from, Mobile to )
		{
			Map map = from.Map;

			if ( map == null || to.Talisman is WisdomOfAncientForest )
				return;

			int x = to.X + Utility.RandomMinMax( -1, 1 );
			int y = to.Y + Utility.RandomMinMax( -1, 1 );
			int z = to.Z;

			SelfDeletingItem web = new SelfDeletingItem( 3812, "a web", 5 );

			from.MovingEffect( to, 0xee6, 7, 1, false, false, 0x481, 0 );
			to.Paralyze( TimeSpan.FromSeconds( 6 ) );
			to.SendMessage( "Jsi {0} v pavucine!", ( to.Female ) ? "chycena" : "chycen" );
			web.MoveToWorld( new Point3D( x, y, z ), map );
			to.ApplyPoison( from, Poison.Greater );
		}

		public override void OnDamagedBySpell( Mobile from )
		{
			if ( from != null && from != this && 0.33 > Utility.RandomDouble() )
			{
				WebAttack( this, from );
			}

			base.OnDamagedBySpell( from );
		}

		public override void OnGotMeleeAttack( Mobile attacker )
		{
			if ( attacker != null && attacker != this && 0.33 > Utility.RandomDouble() )
			{
				WebAttack( this, attacker );
			}

			base.OnGotMeleeAttack( attacker );
		}

		public SpiderKing( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}
