using System;
using Server;
using Server.Misc;
using Server.Items;
using Server.Engines.CannedEvil;
using Server.Targeting;
using System.Collections;
using System.Collections.Generic;

namespace Server.Mobiles
{
	public class StrongRabbit : BaseChampion
	{
		public override ChampionSkullType SkullType { get { return ChampionSkullType.Power; } }

		private DateTime m_Delay = DateTime.Now;

		public override WeaponAbility GetWeaponAbility()
		{
			switch (Utility.Random(3))
			{
				default:
					case 0: return WeaponAbility.DoubleStrike;
				case 1: return WeaponAbility.WhirlwindAttack;
				case 2: return WeaponAbility.CrushingBlow;
			}
		}

		[Constructable]
		public StrongRabbit() : this (false, 6)
		{
		}

		[Constructable]
		public StrongRabbit(int range) : this (false, range)
		{
		}

		[Constructable]
		public StrongRabbit(bool ischampion, int range) : base(AIType.AI_Necromage, FightMode.Closest, ischampion, range)
		{
			Name = "a rabbit";
			Body = 205;
			Hue = 1925;

			SetStr(1250, 1300);
			SetDex(190, 260);
			SetInt(850, 1000);

			SetDamage(20, 40);
			SetHits(12000, 15000);
			SetMana(10000);

			SetDamageType(ResistanceType.Physical, 50);
			SetDamageType(ResistanceType.Cold, 50);

			switch (Utility.Random(5))
			{
				case 0:
				{
					SetResistance(ResistanceType.Physical, 95, 100);
					SetResistance(ResistanceType.Fire, 95, 100);
					SetResistance(ResistanceType.Cold, 95, 100);
					SetResistance(ResistanceType.Poison, 95, 100);
					SetResistance(ResistanceType.Energy, 95, 100);
				}

				break;
				case 1:
				{
					SetResistance(ResistanceType.Physical, 95, 100);
					SetResistance(ResistanceType.Fire, 95, 100);
					SetResistance(ResistanceType.Cold, 95, 100);
					SetResistance(ResistanceType.Poison, 95, 100);
					SetResistance(ResistanceType.Energy, 95, 100);
				}

				break;
				case 2:
				{
					SetResistance(ResistanceType.Physical, 95, 100);
					SetResistance(ResistanceType.Fire, 95, 100);
					SetResistance(ResistanceType.Cold, 95, 100);
					SetResistance(ResistanceType.Poison, 95, 100);
					SetResistance(ResistanceType.Energy, 95, 100);
				}

				break;
				case 3:
				{
					SetResistance(ResistanceType.Physical, 95, 100);
					SetResistance(ResistanceType.Fire, 95, 100);
					SetResistance(ResistanceType.Cold, 95, 100);
					SetResistance(ResistanceType.Poison, 95, 100);
					SetResistance(ResistanceType.Energy, 95, 100);
				}

				break;
				case 4:
				{
					SetResistance(ResistanceType.Physical, 95, 100);
					SetResistance(ResistanceType.Fire, 95, 100);
					SetResistance(ResistanceType.Cold, 95, 100);
					SetResistance(ResistanceType.Poison, 95, 100);
					SetResistance(ResistanceType.Energy, 95, 100);
				}

				break;
			}

			SetSkill(SkillName.MagicResist, 180.1, 230.0);
			SetSkill(SkillName.EvalInt, 180.6, 260.5);
			SetSkill(SkillName.Necromancy, 230.6, 260.5);
			SetSkill(SkillName.SpiritSpeak, 150.1, 180.5);
			SetSkill(SkillName.Magery, 190.1, 250.1);
			SetSkill(SkillName.Poisoning, 90.5);
			SetSkill(SkillName.Meditation, 160.0);
			SetSkill(SkillName.Tactics, 270.1, 320.0);
			SetSkill(SkillName.Wrestling, 270.1, 320.0);
			SetSkill(SkillName.Parry, 90.1, 180.0);
			SetSkill(SkillName.Anatomy, 120.1, 180.0);

			Fame = 20000;
			Karma = -15000;
			VirtualArmor = 55;
		}

		public override int GetAttackSound()
		{
			return 0xC9;
		}

		public override int GetHurtSound()
		{
			return 0xCA;
		}

		public override int GetDeathSound()
		{
			return 0xCB;
		}

		public override void GenerateLoot()
		{
			AddLoot(LootPack.UltraRich, 2);
			AddLoot(LootPack.Gems);
		}

		public override void OnThink()
		{
			if (DateTime.Now > m_Delay)
			{
				Ability.Aura(this, 50, 100, 2, 14, 0, "The icy cold wind chills you to the bone", false);
				m_Delay = DateTime.Now + TimeSpan.FromSeconds(Utility.RandomMinMax(10, 15));
			}

			base.OnThink();
		}

		public override void OnDamage(int amount, Mobile from, bool willKill, int typ)
		{
			base.OnDamage(amount, from, willKill, typ);

			if (from == null)
				return;

			if (Utility.RandomDouble() < 0.07)
				Summon(from);

			if (Utility.RandomDouble() < 0.07 && from != null && from != this && this.CanSee(from))
			{
				SpillAcid(TimeSpan.FromSeconds(10), 10, 40, from);
			}

			// teleports to player
			if (from is PlayerMobile && !InRange(from.Location, 4) && Utility.RandomDouble() < 0.07)
			{
				Combatant = from;

				this.MoveToWorld(from.Location, from.Map);
				this.FixedParticles(0x376A, 9, 32, 0x13AF, EffectLayer.Waist);
				this.PlaySound(0x1FE);
			}

			if (Utility.RandomDouble() < 0.075)
			{
				ArrayList targets = new ArrayList();

				foreach (Mobile m in this.GetMobilesInRange(10))
				{
					if (m == null || m.Deleted)
						continue;

					if (m == this || !CanBeHarmful(m))
						continue;

					if (m is BaseCreature && ((BaseCreature)m).Summoned)
						targets.Add(m);
				}

				for (int i = 0; i < targets.Count; ++i)
				{
					Mobile m = (Mobile)targets[i];

					if (m == null || m.Deleted)
						continue;

					m.Kill();
				}
			}
		}

		public override void OnGotMeleeAttack(Mobile attacker)
		{
			base.OnGotMeleeAttack(attacker);
			attacker.Stam -= Utility.Random(6, 16);
			attacker.Mana -= Utility.Random(4, 20);
			Ability.TurnPet(attacker);
		}

		public override void OnGaveMeleeAttack(Mobile defender)
		{
			base.OnGaveMeleeAttack(defender);

			if (0.04 >= Utility.RandomDouble())
				Ability.CriticalHit(defender);
		}

		public void Summon(Mobile from)
		{
			Map map = this.Map;

			if (map == null || from == null)
				return;

			Mobile targ = null;

			if (from is PlayerMobile && from.Map == map)
				targ = from;

			MadSquirrel summon = new MadSquirrel(targ, 1.0);

			if (summon == null)
				return;

			bool validLocation = false;
			Point3D loc = this.Location;

			for (int j = 0; !validLocation && j < 10; ++j)
			{
				int x = X + Utility.Random(3) - 1;
				int y = Y + Utility.Random(3) - 1;
				int z = map.GetAverageZ(x, y);

				if (validLocation = map.CanFit(x, y, this.Z, 16, false, false))
					loc = new Point3D(x, y, Z);
				else if (validLocation = map.CanFit(x, y, z, 16, false, false))
					loc = new Point3D(x, y, z);
			}

			summon.Name = "a rabbit";
			summon.Body = 205;
			summon.Hue = 1925;
			summon.MoveToWorld(loc, map);
		}

		public override bool HasBreath { get { return true; } }
		public override bool AutoDispel { get { return true; } }
		public override bool BardImmune { get { return true; } }
		public override bool CanRummageCorpses { get { return true; } }
		public override bool AlwaysMurderer { get { return true; } }
		public override bool BleedImmune { get { return true; } }
		public override Poison PoisonImmune { get { return Poison.Lethal; } }
		public override Poison HitPoison { get { return Poison.Lethal; } }
		public override int Hides { get { return 50; } }
		public override HideType HideType { get { return HideType.Daemon; } }
		// public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp

		public override void AlterMeleeDamageTo(Mobile to, ref int damage)
		{
			damage = DecreaseDamage(to, damage);

			if (to is Xanthos.Interfaces.IEvoCreature)
				damage *= 5;
		}

		public StrongRabbit(Serial serial) : base(serial)
		{
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);
			writer.Write((int) 0);
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);
			int version = reader.ReadInt();
		}
	}
}