using System;
using Server;
using Server.Misc;

namespace Server.Mobiles
{
	//[CorpseName( "a changeling corpse" )]
	public class SumChangeling : BaseSummoned
	{
		public override InhumanSpeech SpeechType{ get{ return InhumanSpeech.Wisp; } }
      
      [Constructable]
		public SumChangeling () : base( AIType.AI_Mage, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Name = "a changeling";
			Body = 264;
			BaseSoundID = 0x467;

			SetStr( 28, 119 );
			SetDex( 209, 250 );
			SetInt( 308, 396 );

			SetHits( 201, 205 );
			SetStam( 209, 250 );
			SetMana( 308, 396 );

			SetDamage( 23, 28 );

			SetDamageType( ResistanceType.Physical, 100 );
			
			SetResistance( ResistanceType.Physical, 80, 90 );
			SetResistance( ResistanceType.Fire, 40, 46 );
			SetResistance( ResistanceType.Cold, 40, 48 );
			SetResistance( ResistanceType.Poison, 41, 50 );
			SetResistance( ResistanceType.Energy, 40, 50 );

			SetSkill( SkillName.Wrestling, 10.4, 12.3 );
			SetSkill( SkillName.Tactics, 14.0, 18.5 );
			SetSkill( SkillName.MagicResist, 114.1, 132.0 );
			SetSkill( SkillName.Magery, 90.9, 99.8 );
			SetSkill( SkillName.EvalInt, 90.7, 98.7 );
			SetSkill( SkillName.Meditation, 90.4, 98.8 );

			VirtualArmor = 75;
		}
		
		public override Poison PoisonImmune{ get{ return Poison.Lethal; } } // TODO: Immune to poison?
		public override Poison HitPoison{ get{ return Poison.Regular; } }

		public SumChangeling( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}