using System;
using Server;
using Server.Misc;

namespace Server.Mobiles
{
	//[CorpseName( "a daemon corpse" )]
	public class SumDaemon : BaseSummoned
	{
		[Constructable]
		public SumDaemon () : base( AIType.AI_Mage, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Name = NameList.RandomName( "daemon" );
			Body = 9;
			BaseSoundID = 357;

			SetStr( 350 );
			SetDex( 110 );
			SetInt( 150 );

			SetDamage( 14, 21 );

			SetDamageType( ResistanceType.Physical, 0 );
			SetDamageType( ResistanceType.Poison, 100 );

			SetResistance( ResistanceType.Physical, 70 );
			SetResistance( ResistanceType.Fire, 70 );
			SetResistance( ResistanceType.Cold, 70 );
			SetResistance( ResistanceType.Poison, 70, 80 );
			SetResistance( ResistanceType.Energy, 65 );

			SetSkill( SkillName.EvalInt, 100.1, 120.0 );
			SetSkill( SkillName.Meditation, 90.1, 100.0 );
			SetSkill( SkillName.Magery, 100.1, 120.0 );
			SetSkill( SkillName.MagicResist, 100.1, 120.0 );
			SetSkill( SkillName.Tactics, 120.0 );
			SetSkill( SkillName.Wrestling, 100.1, 120.0 );
			SetSkill( SkillName.Poisoning, 90.1, 100.0 );

			VirtualArmor = 58;
		}
		
		public override Poison PoisonImmune{ get{ return Poison.Lethal; } } // TODO: Immune to poison?
		public override Poison HitPoison{ get{ return Poison.Regular; } }

		public SumDaemon( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}