using System;
using Server.Items;

namespace Server.Mobiles
{
	//[CorpseName( "a golem corpse" )]
	public class SumGolem : BaseSummoned
	{
		[Constructable]
		public SumGolem() : base(AIType.AI_Melee, FightMode.Closest, 10, 1, 0.4, 0.8)
		{
			Name = "a golem";
			Body = 752;

			SetStr(251);
			SetDex(75);
			SetInt(100);

			SetHits(210);

			SetDamage(10, 18);

			SetDamageType(ResistanceType.Physical, 100);

			SetResistance(ResistanceType.Physical, 50);
			SetResistance(ResistanceType.Fire, 100);
			SetResistance(ResistanceType.Cold, 40);
			SetResistance(ResistanceType.Poison, 40);
			SetResistance(ResistanceType.Energy, 40);

			SetSkill(SkillName.MagicResist, 190);
			SetSkill(SkillName.Tactics, 75);
			SetSkill(SkillName.Wrestling, 75);

			Fame = 3500;
			Karma = -3500;

			VirtualArmor = 30;
		}

		public override int GetAngerSound()
		{
			return 541;
		}

		public override int GetIdleSound()
		{
			if (!Controlled)
				return 542;

			return base.GetIdleSound();
		}

		public override int GetDeathSound()
		{
			if (!Controlled)
				return 545;

			return base.GetDeathSound();
		}

		public override int GetAttackSound()
		{
			return 562;
		}

		public override int GetHurtSound()
		{
			if (Controlled)
				return 320;

			return base.GetHurtSound();
		}

		public override bool AutoDispel { get { return true; } }
		public override bool BleedImmune { get { return true; } }
		public override bool BardImmune { get { return true; } }
		public override bool Unprovokable { get { return true; } }
		public override bool Uncalmable { get { return true; } }
		public override Poison PoisonImmune { get { return Poison.Lethal; } }
		public override bool IsScaredOfScaryThings { get { return false; } }
		public override bool IsScaryToPets { get { return true; } }

		public SumGolem(Serial serial) : base(serial)
		{
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);
			writer.Write((int) 0);
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);
			int version = reader.ReadInt();
		}
	}
}