using System;
using Server;
using Server.Misc;

namespace Server.Mobiles
{
	//[CorpseName( "a nature's fury corpse" )]
	public class SumNatureFury : BaseSummoned
	{
		[Constructable]
		public SumNatureFury () : base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Name = "a nature's fury";
			Body = 0x33;
			Hue = 0x4001;

			SetStr( 150 );
			SetDex( 150 );
			SetInt( 100 );

			SetHits( 80 );
			SetStam( 250 );
			SetMana( 0 );

			SetDamage( 8, 12 );

			SetDamageType( ResistanceType.Poison, 100 );

			SetResistance( ResistanceType.Physical, 90 );
			SetResistance( ResistanceType.Fire, 50 );
			SetResistance( ResistanceType.Cold, 50 );
			SetResistance( ResistanceType.Poison, 90 );
			SetResistance( ResistanceType.Energy, 50 );
			
			SetSkill( SkillName.Wrestling, 90.0 );
			SetSkill( SkillName.MagicResist, 70.0 );
			SetSkill( SkillName.Tactics, 100.0 );

			Fame = 0;
			Karma = 0;
			VirtualArmor = 25;
		}

		public override bool AlwaysMurderer { get { return true; } }

		public override void MoveToWorld( Point3D loc, Map map )
		{
			base.MoveToWorld( loc, map );
			Timer.DelayCall( TimeSpan.FromSeconds( 0.1 ), DoEffects );
		}

		public void DoEffects()
		{
			FixedParticles( 0x91C, 10, 180, 0x2543, 0, 0, EffectLayer.Waist );
			PlaySound( 0xE );
			PlaySound( 0x1BC );

			if( Alive && !Deleted )
				Timer.DelayCall( TimeSpan.FromSeconds( 7.0 ), DoEffects );
		}

		public SumNatureFury( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}