﻿using System;
using System.Collections;
using Server;
using Server.Misc;
using Server.Items;
using Server.Spells;

namespace Server.Mobiles
{
	//[CorpseName( "an elder treefellow corpse" )]
	public class ElderTreefellow : BaseCreature
	{
		private DateTime m_Summon = DateTime.Now;
		
		public override WeaponAbility GetWeaponAbility()
		{
			return Utility.RandomBool() ? WeaponAbility.Dismount : WeaponAbility.CrushingBlow;
		}

		[Constructable]
		public ElderTreefellow() : base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Name = "an elder treefellow";
			Body = 301;

			SetStr( 920, 1020 );
			SetDex( 31, 55 );
			SetInt( 66, 90 );

			SetHits( 1480, 1620 );

			SetDamage( 16, 25 );

			SetDamageType( ResistanceType.Physical, 100 );

			SetResistance( ResistanceType.Physical, 30, 50 );
			SetResistance( ResistanceType.Fire, 30, 50 );
			SetResistance( ResistanceType.Cold, 60, 75 );
			SetResistance( ResistanceType.Poison, 50, 75 );
			SetResistance( ResistanceType.Energy, 50, 60 );

			SetSkill( SkillName.MagicResist, 95.1, 120.0 );
			SetSkill( SkillName.Tactics, 99.3, 104.0 );
			SetSkill( SkillName.Wrestling, 99.3, 114.0 );
			SetSkill( SkillName.Anatomy, 90.1, 100.0 );

			Fame = 20000;
			Karma = -2500;

			VirtualArmor = 44;
			PackItem( new Log( Utility.RandomMinMax( 33, 74 ) ) );
			PackItem( new Switch() );
			PackItem( new BarkFragment() );
			PackItem( new BrilliantAmber() );
			
			if ( Utility.RandomDouble() < 0.01 )
			{
				switch ( Utility.Random( 5 ))
				{
					case 0: PackItem( new RangerArms() ); break;
					case 1: PackItem( new RangerGloves() ); break;
					case 2: PackItem( new RangerGorget() ); break;
					case 3: PackItem( new RangerChest() ); break;
					case 4: PackItem( new RangerLegs() ); break;
				}
			}
			
			m_NextAbilityTime = DateTime.Now + TimeSpan.FromSeconds( Utility.RandomMinMax( 2, 5 ) );
			m_Summon = DateTime.Now + TimeSpan.FromSeconds( Utility.RandomMinMax( 2, 5 ) );
		}
		
		// 		public override void OnDeath( Container c )
		// 		{
		// 			base.OnDeath( c );
//
		// 			if ( Utility.RandomBool() )
		//             c.DropItem( new ElderTreefellowLeaves() );
		// 		}
		
		private DateTime m_NextAbilityTime;

		public override void OnThink()
		{
			if ( DateTime.Now >= m_NextAbilityTime )
			{
				Mobile combatant = this.Combatant;

				if ( combatant != null && combatant.Map == this.Map && combatant.InRange( this, 12 ) && IsEnemy( combatant ) && !UnderEffect( combatant ) )
				{
					m_NextAbilityTime = DateTime.Now + TimeSpan.FromSeconds( Utility.RandomMinMax( 20, 30 ) );

					// TODO: Forest summon ability

					this.Say( true, "I call a plague of insects to sting your flesh!" );

					m_Table[combatant] = Timer.DelayCall( TimeSpan.FromSeconds( 0.5 ), TimeSpan.FromSeconds( 7.0 ), new TimerStateCallback( DoEffect ), new object[]{ combatant, 0 } );
				}
			}

			base.OnThink();
		}

		private static Hashtable m_Table = new Hashtable();

		public static bool UnderEffect( Mobile m )
		{
			return m_Table.Contains( m );
		}

		public static void StopEffect( Mobile m, bool message )
		{
			Timer t = (Timer)m_Table[m];

			if ( t != null )
			{
				if ( message )
					m.PublicOverheadMessage( Network.MessageType.Emote, m.SpeechHue, true, "* The open flame begins to scatter the swarm of insects *" );

				t.Stop();
				m_Table.Remove( m );
			}
		}

		public void DoEffect( object state )
		{
			object[] states = (object[])state;

			Mobile m = (Mobile)states[0];
			int count = (int)states[1];

			if ( !m.Alive )
			{
				StopEffect( m, false );
			}
			else
			{
				Torch torch = m.FindItemOnLayer( Layer.TwoHanded ) as Torch;

				if ( torch != null && torch.Burning )
				{
					StopEffect( m, true );
				}
				else
				{
					if ( (count % 4) == 0 )
					{
						m.LocalOverheadMessage( Network.MessageType.Emote, m.SpeechHue, true, "* The swarm of insects bites and stings your flesh! *" );
						m.NonlocalOverheadMessage( Network.MessageType.Emote, m.SpeechHue, true, String.Format( "* {0} is stung by a swarm of insects *", m.Name ) );
					}

					m.FixedParticles( 0x91C, 10, 180, 9539, EffectLayer.Waist );
					m.PlaySound( 0x00E );
					m.PlaySound( 0x1BC );

					AOS.Damage( m, this, Utility.RandomMinMax( 30, 40 ), 100, 0, 0, 0, 0, 1 );

					states[1] = count + 1;

					if ( !m.Alive )
						StopEffect( m, false );
				}
			}
		}

		public override void OnActionCombat()
		{
			if ( this.Combatant != null && DateTime.Now > m_Summon )
			{
				Mobile target = this.Combatant;

				this.Say("I call the animals of the forest to aid me!");

				Map map = this.Map;

				if ( map == null )
					return;

				BaseCreature animal = null;

				switch ( Utility.Random( 5 ) )
				{
						case 0: animal = new MeerGrizzlyBear(); break;
						case 1: animal = new MeerGreatHart(); break;
						case 2: animal = new MeerDireWolf(); break;
						case 3: animal = new MeerPanther(); break;
						case 4: animal = new MeerGiantSerpent(); break;
				}

				bool validLocation = false;
				Point3D loc = this.Location;

				for ( int j = 0; !validLocation && j < 10; ++j )
				{
					int x = X + Utility.Random( 3 ) - 1;
					int y = Y + Utility.Random( 3 ) - 1;
					int z = map.GetAverageZ( x, y );

					if ( validLocation = map.CanFit( x, y, this.Z, 16, false, false ) )
						loc = new Point3D( x, y, Z );
					else if ( validLocation = map.CanFit( x, y, z, 16, false, false ) )
						loc = new Point3D( x, y, z );
				}

				animal.Team = this.Team;
				animal.MoveToWorld( loc, map );
				animal.Combatant = target;

				m_Summon = DateTime.Now + TimeSpan.FromSeconds( Utility.RandomMinMax( 30, 45 ) );
			}
			base.OnActionCombat();
		}

		public override Poison PoisonImmune{ get{ return Poison.Lethal; } }
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		public override bool Unprovokable{ get{ return true; } }
		public override bool Uncalmable{ get{ return true; } }

		public override OppositionGroup OppositionGroup
		{
			get{ return OppositionGroup.FeyAndUndead; }
		}

		public override int GetIdleSound()
		{
			return 443;
		}

		public override int GetDeathSound()
		{
			return 31;
		}

		public override int GetAttackSound()
		{
			return 672;
		}

		public override bool BleedImmune{ get{ return true; } }

		public override void GenerateLoot()
		{
			AddLoot( LootPack.UltraRich );
		}

		public ElderTreefellow( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();

			if ( BaseSoundID == 442 )
				BaseSoundID = -1;
		}
	}
}
