
//////////////////////////
//Created by Hammerhand//
////////////////////////
using System;
using System.Collections;
using Server.Items;
using Server.ContextMenus;
using Server.Misc;
using Server.Network;

namespace Server.Mobiles
{
	//[CorpseName("a werewolf corpse")]
	public class Werewolf : BaseCreature
	{
		public override bool ClickTitle{ get{ return false; } }
		public override bool AlwaysMurderer{ get{ return true; } }
		
		private bool m_TrueForm;

		[Constructable]
		public Werewolf() : base(AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4)
		{
			Body = 400;
			Name = NameList.RandomName( "male" );
			Hue = Utility.RandomSkinHue();
			
			Title = "the Wandering Gypsy";
			
			SetStr( 150, 175 );
			SetDex( 105, 135 );
			SetInt( 85, 95 );
			SetHits( 105,125 );
			
			SetResistance( ResistanceType.Physical, 25, 40 );
			SetResistance( ResistanceType.Fire, 25, 40 );
			SetResistance( ResistanceType.Cold, 25, 40 );
			SetResistance( ResistanceType.Poison, 25, 40 );
			SetResistance( ResistanceType.Energy, 25, 40 );

			SetSkill( SkillName.Wrestling, 85.2, 95.6 );
			SetSkill( SkillName.Tactics, 91.5, 99.0 );
			SetSkill( SkillName.MagicResist, 90.6, 96.8);
			SetSkill( SkillName.Anatomy, 100.1, 100.1 );
			SetSkill( SkillName.Fencing, 80.0, 110.0 );
			
			ShortHair hair = new ShortHair();
			hair.Hue = 1044;
			hair.Layer = Layer.Hair;
			hair.Movable = false;

			AddItem( hair );
			
			
			this.Fame = 5000;
			this.Karma = -5000;
			this.VirtualArmor = 55;
			
			switch ( Utility.Random( 3 ))
			{
					case 0: AddItem( new FancyShirt(Utility.RandomNeutralHue()) ); break;
					case 1: AddItem( new Doublet(Utility.RandomNeutralHue()) ); break;
					case 2: AddItem( new FormalShirt(Utility.RandomNeutralHue()) ); break;
			}
			
			AddItem( new Boots( 2646 ) );
			AddItem( new LongPants() );
			AddItem( new SkullCap(Utility.RandomNeutralHue()) );
			AddItem( new GoldEarrings() );
			AddItem( new GoldBeadNecklace() );
			AddItem( new GoldRing() );
			
			if ( 0.03 > Utility.RandomDouble() )
				AddItem( new MarkOfWerewolf() );
				
			if ( 0.05 > Utility.RandomDouble() )
				AddItem( new AmuletOfTheWolf() );
		}
		
		public override void GenerateLoot()
		{
			AddLoot( LootPack.FilthyRich, 2 );
			AddLoot( LootPack.Meager );
		}

		public void Morph()
		{
			if ( m_TrueForm )
				return;

			m_TrueForm = true;

			Name = "Werewolf";
			BodyValue = 250;
			
			switch( Utility.Random( 3 ) )
			{
					case 0: Hue = Utility.RandomNeutralHue(); break; //No, this really isn't accurate ;->
			}
			
			BaseSoundID = 0xE5;
			Title = "";
			
			SetDamage( 15, 25 );
			SetResistance( ResistanceType.Physical, 50, 60 );
			SetResistance( ResistanceType.Fire, 40, 60 );
			SetResistance( ResistanceType.Cold, 40, 60 );
			SetResistance( ResistanceType.Poison, 50, 70 );
			SetResistance( ResistanceType.Energy, 40, 60 );
			
			Hits = HitsMax;
			Stam = StamMax;
			Mana = ManaMax;
			
			PackItem( new Bone( Utility.RandomMinMax( 5, 10 ) ));
			// 	      PackMagicItems( 1, 5 );
			switch ( Utility.Random( 4 ))
			{
					case 0: PackItem( new LeftArm() ); break;
					case 1: PackItem( new RightArm() ); break;
					case 2: PackItem( new LeftLeg() ); break;
					case 3: PackItem( new Head() ); break;
			}
		}
		
		[CommandProperty( AccessLevel.GameMaster )]
		public override int HitsMax{ get{ return m_TrueForm ? 700 : 125; } }

		[CommandProperty( AccessLevel.GameMaster )]
		public override int ManaMax{ get{ return 200; } }
		
		public Werewolf( Serial serial ) : base( serial )
		{
		}

		public override bool OnBeforeDeath()
		{
			if ( m_TrueForm )
			{
				return base.OnBeforeDeath();
			}
			else
			{
				Morph();
				return false;
			}
		}

		public override int Meat { get { return 4; } }
		public override int Hides { get { return 25; } }
		public override FoodType FavoriteFood { get { return FoodType.Meat; } }
		public override bool IsNotScaredOfDeath{ get{ return true; } } //neutika pri malem poctu hp
		
		public override void OnGaveMeleeAttack( Mobile defender )
		{
			base.OnGaveMeleeAttack( defender );

			if( m_TrueForm && 0.1 > Utility.RandomDouble() )
			{
				/* Blood Bath
				 * Start cliloc 1070826
				 * Sound: 0x52B
				 * 2-3 blood spots
				 * Damage: 2 hps per second for 5 seconds
				 * End cliloc: 1070824
				 */

				ExpireTimer timer = (ExpireTimer)m_Table[defender];

				if( timer != null )
				{
					timer.DoExpire();
					defender.SendLocalizedMessage( 1070825 ); // The creature continues to rage!
				}
				else
					defender.SendLocalizedMessage( 1070826 ); // The creature goes into a rage, inflicting heavy damage!

				timer = new ExpireTimer( defender, this );
				timer.Start();
				m_Table[defender] = timer;
			}
		}

		private static Hashtable m_Table = new Hashtable();

		private class ExpireTimer : Timer
		{
			private Mobile m_Mobile;
			private Mobile m_From;
			private int m_Count;

			public ExpireTimer( Mobile m, Mobile from )
				: base( TimeSpan.FromSeconds( 1.0 ), TimeSpan.FromSeconds( 1.0 ) )
			{
				m_Mobile = m;
				m_From = from;
				Priority = TimerPriority.OneSecond;
			}

			public void DoExpire()
			{
				Stop();
				m_Table.Remove( m_Mobile );
			}

			public void DrainLife()
			{
				if( m_Mobile.Alive )
					m_Mobile.Damage( 2, m_From );
				else
					DoExpire();
			}

			protected override void OnTick()
			{
				DrainLife();

				if( ++m_Count >= 5 )
				{
					DoExpire();
					m_Mobile.SendLocalizedMessage( 1070824 ); // The creature's rage subsides.
				}
			}
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );

			writer.Write( m_TrueForm );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();

			switch ( version )
			{
				case 0:
					{
						m_TrueForm = reader.ReadBool();
						break;
					}
			}
		}
	}
}
