using System;
using Server;
using Server.Items;
using Xanthos.Evo;

namespace Server.Mobiles
{
	[CorpseName( "a Daemon corpse" )]
	public class Ancientdaemon : BaseCreature
	{
		[Constructable]
		public Ancientdaemon () : base( AIType.AI_Mage, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Name = "Ancient Daemon";
			Body = 40;
			Hue = 1266;
			BaseSoundID = 357;

			SetStr( 986, 1185 );
			SetDex( 177, 255 );
			SetInt( 151, 250 );

			SetHits( 2792, 2911 );

			SetDamage( 38, 45 );

			SetDamageType( ResistanceType.Physical, 80 );
			SetDamageType( ResistanceType.Fire, 60 );
			SetDamageType( ResistanceType.Energy, 40 );

			SetResistance( ResistanceType.Physical, 75, 90 );
			SetResistance( ResistanceType.Fire, 70, 80 );
			SetResistance( ResistanceType.Cold, 70, 80 );
			SetResistance( ResistanceType.Poison, 100 );
			SetResistance( ResistanceType.Energy, 60, 80 );

			SetSkill( SkillName.Anatomy, 125.1, 170.0 );
			SetSkill( SkillName.EvalInt, 150.1, 190.0 );
			SetSkill( SkillName.Magery, 165.5, 180.0 );
			SetSkill( SkillName.Meditation, 95.1, 150.0 );
			SetSkill( SkillName.MagicResist, 130.5, 180.0 );
			SetSkill( SkillName.Tactics, 180.1, 210.0 );
			SetSkill( SkillName.Wrestling, 150.1, 190.0 );

			Fame = 24000;
			Karma = -24000;

			VirtualArmor = 95;

			PackItem( new Longsword() );
			PackItem(new RaelisDemonioDust(Utility.RandomMinMax(200, 600)));
		}

		public override void GenerateLoot()
		{
			AddLoot( LootPack.FilthyRich, 3 );
			AddLoot( LootPack.MedScrolls, 3 );
			PackGold( 1360, 1635 );
		}

		public override bool CanRummageCorpses{ get{ return true; } }
		public override Poison PoisonImmune{ get{ return Poison.Deadly; } }
		public override int TreasureMapLevel{ get{ return 5; } }
		public override int Meat{ get{ return 1; } }

		public Ancientdaemon( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}