///////////Made By Admin Andromeda////////////////
//////////////Dark Souls////////////////
/////////////////Death set/////////////////

using System;
using Server;
using Server.Items;

namespace Server.Mobiles
{
	[CorpseName( "a death Warrior corpse" )]
	public class DeathWarrior : BaseCreature
	{
		[Constructable]
		public DeathWarrior () : base( AIType.AI_Melee, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Name = "Death Warrior";
			Body = 0x3CA;
			Hue = 1153;
			BaseSoundID = 357;

			SetStr( 350, 390 );
			SetDex( 200, 250 );
			SetInt( 200, 250 );

			SetHits( 600, 900 );

			SetDamage( 40, 50 );

			SetDamageType( ResistanceType.Physical, 50 );
			SetDamageType( ResistanceType.Fire, 25 );
			SetDamageType( ResistanceType.Energy, 25 );

			SetResistance( ResistanceType.Physical, 90, 100 );
			SetResistance( ResistanceType.Fire, 60, 70 );
			SetResistance( ResistanceType.Cold, 60, 70 );
			SetResistance( ResistanceType.Poison, 5, 10 );
			SetResistance( ResistanceType.Energy, 60, 70 );

			SetSkill( SkillName.Anatomy, 110, 120 );
			SetSkill( SkillName.EvalInt, 0, 0 );
			SetSkill( SkillName.Magery, 0, 0 );
			SetSkill( SkillName.Meditation, 0, 0 );
			SetSkill( SkillName.MagicResist, 75, 85 );
			SetSkill( SkillName.Tactics, 100, 120 );
			SetSkill( SkillName.Wrestling, 100, 120 );
			SetSkill( SkillName.Swords, 100, 110 );


			Fame = 24000;
			Karma = -24000;

			VirtualArmor = 120;

			switch ( Utility.Random( 8 ))
			{
				case 0: PackItem( new Bandana( 1153 ) ); break;
				case 1: PackItem( new FancyShirt( 1153 ) ); break;
     		case 2: PackItem( new Sandals( 1153 ) ); break;
				case 3: PackItem( new LongPants( 1153) ); break;
				case 4: PackItem( new Robe( 1 ) ); break;
			}

			switch ( Utility.Random( 8 ))
			{
				case 0: PackItem( new SpidersSilk( 0 ) ); break;
				case 1: PackItem( new BlackPearl( 0 ) ); break;
				case 2: PackItem( new Bloodmoss( 0 ) ); break;
				case 3: PackItem( new Garlic( 0 ) ); break;
				case 4: PackItem( new MandrakeRoot( 0 ) ); break;
				case 5: PackItem( new Nightshade( 0 ) ); break;
				case 6: PackItem( new SulfurousAsh( 0 ) ); break;
				case 7: PackItem( new Ginseng( 0 ) ); break;
			}

			PackItem( new Longsword() );
			PackGold( 1000, 2000 );
			PackScroll( 2, 4 );
			PackWeapon( 3, 5 );
			PackSlayer();
			
		}

		public override bool CanRummageCorpses{ get{ return true; } }
		public override bool AlwaysMurderer{ get{ return true; } }
		public override int  TreasureMapLevel{ get{ return 6; } }
		public override int  Meat{ get{ return 1; } }

		public DeathWarrior( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}