///////////Creado por Admin Andromeda////////////////
//////////////Brumas Eternas////////////////
/////////////////Death set/////////////////

using System;
using Server;
using Server.Items;

namespace Server.Mobiles
{
	[CorpseName( "a death mage corpse" )]
	public class Deathmage : BaseCreature
	{
		[Constructable]
		public Deathmage () : base( AIType.AI_Mage, FightMode.Closest, 10, 1, 0.2, 0.4 )
		{
			Name = "Death Mage";
			Body = 0x3CA;
			Hue = 1153;
			BaseSoundID = 357;

			SetStr( 350, 390 );
			SetDex( 200, 250 );
			SetInt( 200, 250 );

			SetHits( 600, 900 );

			SetDamage( 40, 50 );

			SetDamageType( ResistanceType.Physical, 50 );
			SetDamageType( ResistanceType.Fire, 25 );
			SetDamageType( ResistanceType.Energy, 25 );

			SetResistance( ResistanceType.Physical, 90, 100 );
			SetResistance( ResistanceType.Fire, 60, 70 );
			SetResistance( ResistanceType.Cold, 60, 70 );
			SetResistance( ResistanceType.Poison, 5, 10 );
			SetResistance( ResistanceType.Energy, 60, 70 );

			SetSkill( SkillName.Anatomy, 0, 0 );
			SetSkill( SkillName.EvalInt, 100, 120 );
			SetSkill( SkillName.Magery, 120, 140 );
			SetSkill( SkillName.Meditation, 110, 120 );
			SetSkill( SkillName.MagicResist, 80, 95 );
			SetSkill( SkillName.Tactics, 100, 120 );
			SetSkill( SkillName.Wrestling, 100, 120 );
			SetSkill( SkillName.Swords, 0, 0 );


			Fame = 24000;
			Karma = -24000;

			VirtualArmor = 120;

		  	switch ( Utility.Random( 8 ))
			{
				case 0: PackItem( new Bandana( 1153 ) ); break;
				case 1: PackItem( new FancyShirt( 1153 ) ); break;
     		case 2: PackItem( new Sandals( 1153 ) ); break;
				case 3: PackItem( new LongPants( 1153) ); break;
				case 4: PackItem( new Robe( 1 ) ); break;
				case 5: PackItem( new SpidersSilk( 10 ) ); break;
				case 6: PackItem( new BlackPearl( 10 ) ); break;
				case 7: PackItem( new Bloodmoss( 10 ) ); break;
				case 8: PackItem( new Garlic( 10 ) ); break;
				case 9: PackItem( new MandrakeRoot( 10 ) ); break;
				case 10: PackItem( new Nightshade( 10 ) ); break;
				case 11: PackItem( new SulfurousAsh( 10 ) ); break;
				case 12: PackItem( new Ginseng( 10 ) ); break;
			}

			PackItem( new Longsword() );
			PackGold( 1000, 2000 );
			PackScroll( 2, 4 );
			PackWeapon( 3, 5 );
			PackSlayer();
			
		}

		public override bool CanRummageCorpses{ get{ return true; } }
		public override bool AlwaysMurderer{ get{ return true; } }
		public override int  TreasureMapLevel{ get{ return 6; } }
		public override int  Meat{ get{ return 1; } }

		public Deathmage( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}