// LootData.cs
// Author: Oak (ssalter)
// Version: 1.0
// Requirements: Runuo 2.0, XmlSpawner2
// Server Tested with: 2.0 build 64
// Revision Date: 7/1/2006
// Purpose: Player can type 'grab options' to get a gump and select what types of items they want to transfer
// to their lootbag when using the 'claim' command. Uses XMLAttachment for loot options

using System;
using Server;
using Server.Items;
using Server.Network;
using Server.Mobiles;

namespace Server.Engines.XmlSpawner2
{
	public class AnimalTrainerAttachment : XmlAttachment
	{
		private int m_Count;

		[CommandProperty( AccessLevel.GameMaster )]
		public int Count { get { return m_Count; } set { m_Count  = value; } }

		public AnimalTrainerAttachment(ASerial serial) : base(serial)
		{
		}

		[Attachable]
		public AnimalTrainerAttachment()
		{
         Name = "Animal Trainer";
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize(writer);

			writer.Write( (int) 0 );
			// version 0
			writer.Write(m_Count);
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);
			// version 0
			int version = reader.ReadInt();
			m_Count = reader.ReadInt();
		}
	}
}
