using System;
using Server;
using Server.Mobiles;
using Server.Gumps;

namespace Server.Items
{
	public class AuberonuvZub : Item
	{
		[Constructable]
		public AuberonuvZub() : this( 1 )
		{
		}
		
		[Constructable]
		public AuberonuvZub( int amount ) : base( 3985 )
		{
			Stackable = true;
			Name = "Auberonuv Zub";
			Weight = 0.1;
			Hue = 1161;
			Amount = amount;
		}

		public AuberonuvZub( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			
			int version = reader.ReadInt();
		}
		
		public override void OnDoubleClick( Mobile from )
		{
			if ( IsChildOf( from.Backpack ) )
			{
				if ( from is PlayerMobile )
				{
      			if (from.HasGump( typeof( ConfirmUseZub ) ) )
      				from.CloseGump(typeof( ConfirmUseZub ) );
      			from.SendGump( new ConfirmUseZub( this ) );
				}
			}
			else
			{
				from.SendLocalizedMessage( 1042010 ); // You must have the object in your backpack to use it.
			}
		}
		
		private class ConfirmUseZub : BaseConfirmGump
		{
			public override int TitleNumber{ get{ return 1075083; } } // <center>Warning!</center>
			public override int LabelNumber{ get{ return 1074975; } } // Are you sure you wish to select this?
			
			private Item m_Item;
			
			public ConfirmUseZub( Item item ) : base()
			{
				m_Item = item;
			}
			
			public override void Confirm( Mobile from )
			{		
			   if ( m_Item == null || m_Item.Deleted )
				  return;
				  
				if ( from is PlayerMobile )
				{
    				((PlayerMobile)from).Zuby += 1;
    				from.SendMessage( "Zub ti byl pripsan." );
    				from.SendMessage( "Mas {0} zubu.", ((PlayerMobile)from).Zuby );
    				m_Item.Consume();
				}
			}
		}
	}
}
