using System;
using System.Collections;
using System.Collections.Generic;
using Server;
using Server.Mobiles;
using System.IO;
using Server.Network;

namespace Server.Items
{
    public class CechovniFontana : Container
    {
        public override int DefaultMaxWeight { get { return 0; } } // A value of 0 signals unlimited weight
        public override bool Decays { get { return false; } }
        public override bool DisplayWeight { get { return false; } }
        public override bool DisplaysContent { get { return false; } }
        public override bool IsPublicContainer { get { return true; } }
        public override bool IsDecoContainer { get { return false; } }
        // 		public override string DefaultName { get { return "Collector"; } }

        [Constructable]
        public CechovniFontana() : base(10944)
        {
            Movable = false;
            LiftOverride = false;
            Name = "Cechovni Fontana";
        }

        public CechovniFontana(Serial serial) : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);
            writer.Write((int)0); // version
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);
            int version = reader.ReadInt();
        }

        public override bool OnDragDrop(Mobile from, Item dropped)
        {
            if ((dropped is SkillBall && dropped.ItemID != 5360) || dropped is MagicalWire || dropped is MagicScroll
               || dropped is GinsengPlant || dropped is NightshadePlant || dropped is MandrakePlant || dropped is PetPowerScroll
               || dropped is LevelUpScroll || dropped is PowerScroll || dropped is BaseTalisman || dropped is ILevelable || dropped is UnholyRune)
            {
                Effects.SendLocationParticles(EffectItem.Create(Location, Map, EffectItem.DefaultDuration), 0x376A, 9, 32, 5024);
                from.PlaySound(0x2E6); //drop gold sound

                int mince = 0;

                if (dropped is SkillBall)
                {
                    mince += (int)((SkillBall)dropped).SkillBonus;
                }
                else if (dropped is UnholyRune)
                {
                    mince += dropped.Amount * 30;
                }
                else if (dropped is MagicalWire)
                {
                    mince += (int)((MagicalWire)dropped).Bonus;
                }
                else if (dropped is MagicScroll)
                {
                    mince += (int)(((MagicScroll)dropped).ScrollValue * 2);
                }
                else if (dropped is NightshadePlant)
                {
                    mince += 2;
                }
                else if (dropped is ILevelable)
                {
                    if (dropped is BaseWeapon && ((BaseWeapon)dropped).ArtifactRarity > 0)
                        mince += 15;

                    else if (dropped is BaseArmor && ((BaseArmor)dropped).ArtifactRarity > 0)
                        mince += 15;

                    else if (dropped is BaseJewel && ((BaseJewel)dropped).ArtifactRarity > 0)
                        mince += 15;

                    else if (dropped is BaseClothing && ((BaseClothing)dropped).ArtifactRarity > 0)
                        mince += 15;

                    else
                        mince += 5;
                }
                else if (dropped is LevelUpScroll || dropped is PowerScroll || dropped is PetPowerScroll)
                {
                    int val = 0;

                    if (dropped is PowerScroll)
                        val = (int)(((PowerScroll)dropped).Value - 100);
                    else if (dropped is LevelUpScroll)
                        val = (int)((LevelUpScroll)dropped).Value;
                    else if (dropped is PetPowerScroll)
                        val = (int)(((PetPowerScroll)dropped).Value - 100);

                    if (val == 5) mince += 3;
                    else if (val == 10) mince += 6;
                    else if (val == 15) mince += 9;
                    else if (val == 20) mince += 12;
                }
                else
                    mince = 1;

                if (mince < 1)
                    mince = 1;

                from.SendMessage(193, "Pocet ziskanych cechovnich minci: {0}", mince.ToString());
                from.AddToBackpack(new CechovniMince(mince));
                dropped.Delete();
            }
            else if (dropped is ArmsOfCompassion || dropped is CloakOfHumility || dropped is DupresShield || dropped is GauntletsOfValor ||
               dropped is GorgetOfTruth || dropped is HelmOfSpirituality || dropped is LegsOfHonor || dropped is PlateOfJustice || dropped is SolaretsOfSacrifice ||
               (dropped is Hay1 && dropped.Name.Equals("honor ingots", StringComparison.OrdinalIgnoreCase)) ||
               (dropped is Hay2 && dropped.Name.Equals("honor ore", StringComparison.OrdinalIgnoreCase)))
            {
                Effects.SendLocationParticles(EffectItem.Create(Location, Map, EffectItem.DefaultDuration), 0x376A, 9, 32, 5024);
                from.PlaySound(0x2E6); //drop gold sound

                from.SendMessage(193, "Pocet ziskanych cechovnich minci: 100");
                from.AddToBackpack(new CechovniMince(100));
                dropped.Delete();
            }
            else
            {
                from.SendMessage("Vhazuj pouze skill bally, power scrolly, rostlinky pro pety, talismany, unholy rune, honor ore a ingoty, levelovaci predmety, magicke draty a svitky.");
                return false;
            }

            return false;
        }

        public override void OnDoubleClick(Mobile from)
        {
            if ((int)from.AccessLevel > (int)AccessLevel.Counselor)
                base.OnDoubleClick(from);
            else
                from.SendMessage("Na dne fontany vidis plno minci...");
        }

        public override bool CheckLift(Mobile from, Item item, ref LRReason reject)
        {
            if ((int)from.AccessLevel > (int)AccessLevel.Player)
                return base.CheckLift(from, item, ref reject);
            else
                reject = LRReason.CannotLift;

            return false;
        }
    }
}
