using System;
using Server;

namespace Server.Items
{
	public class CechovniMince : Item
	{
		[Constructable]
		public CechovniMince() : this( 10 )
		{
		}

		[Constructable]
		public CechovniMince( int amountFrom, int amountTo ) : this( Utility.RandomMinMax( amountFrom, amountTo ) )
		{
		}

		[Constructable]
		public CechovniMince( int amount ) : base( 3824 )
		{
			Stackable = true;
			Name = "Cechovni mince";
 			Hue = 2544;
			Weight = 0.1;
			Amount = amount;
		}

		public CechovniMince( Serial serial ) : base( serial )
		{
		}

		public override int GetDropSound()
		{
			if ( Amount <= 1 )
				return 0x2E4;
			else if ( Amount <= 5 )
				return 0x2E5;
			else
				return 0x2E6;
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}