using System;
using Server;
using Server.Mobiles;
using Server.Gumps;

namespace Server.Items
{
	public class ExpyItem : Item
	{
        private int m_Bonus = 1;

        [CommandProperty(AccessLevel.GameMaster)]
        public int Bonus
        {
            get { return m_Bonus; }
            set
            {
               m_Bonus = value;
               
               if ( m_Bonus < 1 )
                  m_Bonus = 1;
            }
         }
      
      [Constructable]
		public ExpyItem() : this( 1/*( ( 0.2 > Utility.RandomDouble() ) ? 2 : 1 )*/ )
		{
		}
		
		[Constructable]
		public ExpyItem( int bonus ) : base( 0x1ECD /*Utility.RandomMinMax( 3340, 3353 )*/ )
		{
			Stackable = false;
			Name = "soutezni krystal";
			Weight = 0.1;
			Light = LightType.Circle300;
			Movable = false;
			//Hue = Utility.RandomMinMax( 2589, 2611 );
			m_Bonus = bonus;
		}

		public ExpyItem( Serial serial ) : base( serial )
		{
		}

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)0); // version
            writer.Write((int)m_Bonus);
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();

            switch (version)
            {

                case 0:
                    {
                        m_Bonus = reader.ReadInt();
                        break;
                    }
            }
        }
		
		public override void OnDoubleClick( Mobile from )
		{
			base.OnDoubleClick( from );
			
         if ( ( from.InRange( this, 2 ) && from.InLOS( this ) ) || this.Parent != null )
			{
				if ( from is PlayerMobile )
				{
      			if (from.HasGump( typeof( ConfirmUseItem ) ) )
      				from.CloseGump(typeof( ConfirmUseItem ) );
      			from.SendGump( new ConfirmUseItem( this ) );
				}
			}
			else
			   from.SendMessage( "Jsi prilis daleko" );
		}
		
		private class ConfirmUseItem : BaseConfirmGump
		{
			public override int TitleNumber{ get{ return 1075083; } } // <center>Warning!</center>
			public override int LabelNumber{ get{ return 1074975; } } // Are you sure you wish to select this?
			
			private ExpyItem m_Item;
			
			public ConfirmUseItem( ExpyItem item ) : base()
			{
				m_Item = item;
			}
			
			public override void Confirm( Mobile from )
			{		
			   if ( m_Item == null || m_Item.Deleted )
				  return;
				  
				if ( from is PlayerMobile )
				{
    				((PlayerMobile)from).Expy += m_Item.Bonus;
    				from.SendMessage( "Ziskavas {0} bodu.", m_Item.Bonus );
    				from.SendMessage( "Celkem mas {0} bodu.", ((PlayerMobile)from).Expy );
    				m_Item.Delete();
				}
			}
		}
	}
}
