using System;
using Server;

namespace Server.Items
{
    public class Predmet : Item
    {
        [Constructable]
        public Predmet() : base(0x14F0)
        {
            Weight = 1.0;
            LootType = LootType.Blessed;
            Name = "Predmet";
        }

        public override void GetProperties(ObjectPropertyList list)
        {
            base.GetProperties(list);
            Server.Engines.XmlSpawner2.XmlAttach.AddAttachmentProperties(this, list);
        }

        public Predmet(Serial serial) : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)0); // version
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();
        }
    }
}