using System;
using Server;
using Server.Network;

namespace Server.Items
{
	public class RybarskySud : Container
	{
		public override int DefaultMaxWeight{ get{ return 0; } } // A value of 0 signals unlimited weight
		public override bool Decays{ get{ return false; } }
		public override bool DisplayWeight { get { return false; } }
		public override bool DisplaysContent{ get{ return false; } }
		public override bool IsPublicContainer{ get{ return true; } }
		public override bool IsDecoContainer{ get{ return false; } }
		// 		public override string DefaultName { get { return "Collector"; } }

		[Constructable]
		public RybarskySud() : base( 3703/*0x9A8*/ )
		{
			Movable = false;
			LiftOverride = false;
			Name = "Sud na ryby";
		}
		
		public RybarskySud( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );			
			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );			
			int version = reader.ReadInt();
		}

		public override bool OnDragDrop( Mobile from, Item dropped )
		{
         if ( dropped is FishCoral || dropped is FishAlbinoAngelfish || dropped is FishBladePlant || dropped is FishAngelfish || 
         dropped is FishBlueCory || dropped is FishBrineShrimp || dropped is FishShrimp || dropped is FishSmallmouthSuckerfish || 
         dropped is FishVesperReefTiger || dropped is FishMinocBlue || dropped is FishNujelmHoney || dropped is FishFishies ||
         dropped is FishRainbowMolly || dropped is FishClownfish || dropped is FishGoldenBroadtail || dropped is FishFandancer ||
         dropped is FishBritainiaCrownFish || dropped is FishJellyfish || dropped is BigFish ||
         dropped is FishSpeckledCrab || dropped is FishSpottedBucaneer || dropped is FishSpottedPuffer || dropped is FishStripedSosarianSwill )
         {
				Effects.SendLocationParticles( EffectItem.Create( Location, Map, EffectItem.DefaultDuration ), 0x376A, 9, 32, 5024 );
				Effects.PlaySound( Location, Map, 0x1FF );
				
				from.AddToBackpack( new FishSeaHorse() );
				dropped.Delete();
				return true;
			}
         else
         {
            from.SendMessage( "Toto neni pozadovana ryba." );
            return false;
         }
         
         return false;
		}

		public override void OnDoubleClick( Mobile from )
		{
			if ( (int) from.AccessLevel > (int) AccessLevel.Counselor )
			   base.OnDoubleClick( from );
			else
			   from.SendMessage( "Zamceno." );
		}

		public override bool CheckLift( Mobile from, Item item, ref LRReason reject )
		{
			if ( (int) from.AccessLevel > (int) AccessLevel.Player )
				return base.CheckLift( from, item, ref reject );
			else
				reject = LRReason.CannotLift;
			
			return false;
		}
	}
}
