using System;
using System.Collections;
using System.Collections.Generic;
using Server;
using Server.Mobiles;
using System.IO;
using Server.Network;
using Server.Engines.Craft;
using Server.ContextMenus;

using Server.Accounting;

namespace Server.Items
{
	public class SoutezniTruhla : Container
	{
		public override int DefaultMaxWeight{ get{ return 0; } } // A value of 0 signals unlimited weight
		public override bool Decays{ get{ return false; } }
		public override bool DisplayWeight { get { return false; } }
		public override bool DisplaysContent{ get{ return false; } }
		// 		public override bool IsPublicContainer{ get{ return true; } }
		public override bool IsDecoContainer{ get{ return false; } }
		// 		public override string DefaultName { get { return "Collector"; } }
		
		private bool m_Bonus = false;
		
		[CommandProperty(AccessLevel.GameMaster)]
		public bool Bonus
		{
			get { return m_Bonus; }
			set { m_Bonus = value; }
		}
		
		[Constructable]
		public SoutezniTruhla() : base( 0x9A8 )
		{
			Movable = false;
			// 			LiftOverride = false;
			Name = "Soutezni truhla";
			Hue = 193;
			Weight = 1;
		}
		
		public SoutezniTruhla( Serial serial ) : base( serial )
		{
		}
		
		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);
			
			writer.Write((int)1); // version
			writer.Write((bool)m_Bonus);
		}
		
		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);
			
			int version = reader.ReadInt();
			
			switch (version)
			{
				
				case 1:
				{
					m_Bonus = reader.ReadBool();
					break;
				}
			}
		}
        
		/*
			// ============= RUNIC SOUTEZ START
			private static int ResourcePoints( CraftResource res )
			{
			switch ( res )
			{
            case CraftResource.DullCopper: return 2; break;
            case CraftResource.ShadowIron: return 3; break;
            case CraftResource.Copper: return 4; break;
            case CraftResource.Bronze: return 5; break;
            case CraftResource.Gold: return 6; break;
            case CraftResource.Agapite: return 7; break;
            case CraftResource.Verite: return 8; break;
            case CraftResource.Valorite: return 9; break;
            case CraftResource.Silver: return 10; break;
            case CraftResource.Platinum: return 11; break;
            case CraftResource.Mythril: return 12; break;
            case CraftResource.Obsidian: return 13; break;
            case CraftResource.Jade: return 14; break;
            case CraftResource.Moonstone: return 15; break;
            case CraftResource.Sunstone: return 16; break;
            case CraftResource.Bloodstone: return 17; break;
            
            case CraftResource.SpinedLeather: return 2; break;
            case CraftResource.HornedLeather: return 3; break;
            case CraftResource.BarbedLeather: return 4; break;
            case CraftResource.DragonLeather: return 10; break;
            case CraftResource.DaemonLeather: return 11; break;
            
            case CraftResource.Pine: return 2; break;
            case CraftResource.Cedar: return 3; break;
            case CraftResource.Cherry: return 4; break;
            case CraftResource.Mahogany: return 5; break;            
            case CraftResource.Oak: return 6; break;
            case CraftResource.Ash: return 7; break;
            case CraftResource.Yew: return 8; break;
            case CraftResource.Heartwood: return 12; break;
            case CraftResource.Bloodwood: return 14; break;
            case CraftResource.Frostwood: return 16; break;
            case CraftResource.RedScales: return 5; break;
            case CraftResource.YellowScales: return 5; break;
            case CraftResource.BlackScales: return 5; break;
            case CraftResource.GreenScales: return 5; break;
            case CraftResource.WhiteScales: return 5; break;
            case CraftResource.BlueScales: return 5; break;
            default: return 1; break;
			}
			}
			
			public static void ComputePoints( Item item, Mobile from, BaseRunicTool tool, CraftSystem system )
			{
			//KONTROLY
			if ( !( from is PlayerMobile ) || item == null || tool == null || system == null )
			return;
			
			CraftResourceInfo resInfo = CraftResources.GetInfo( tool.Resource );
			
			if ( resInfo == null )
			return;
			
			CraftAttributeInfo attrs = resInfo.AttributeInfo;
			
			if ( attrs == null )
			return;
			
			int reward = 0;
			int resAmount = 0;
			CraftResource res;
			CraftItem craftItem = system.CraftItems.SearchFor( item.GetType() );
			
			if ( item is BaseWeapon )
            res = ((BaseWeapon)item).Resource;
			else if ( item is BaseArmor )
            res = ((BaseArmor)item).Resource;
			else
            res = CraftResource.Iron;
			
			if ( craftItem != null && craftItem.Ressources.Count >= 1 && craftItem.Ressources.GetAt( 0 ).Amount > 0 )
			resAmount = craftItem.Ressources.GetAt( 0 ).Amount;
			
			reward = ( ( attrs.RunicMinAttributes + attrs.RunicMaxAttributes + attrs.RunicMinIntensity + attrs.RunicMaxIntensity ) * ( ResourcePoints( res ) * resAmount ) );
			reward /= 10;
			
			//          from.SendMessage( "Res Points: {0}, Res Amount: {1}, Runic: {2}.", ResourcePoints( res ), resAmount, ( attrs.RunicMinAttributes + attrs.RunicMaxAttributes + attrs.RunicMinIntensity + attrs.RunicMaxIntensity ) );
			
			PlayerMobile pm = ( PlayerMobile ) from;
			pm.Expy += reward;
			
			from.SendMessage( "Ziskavas {0} bodu.", reward );
			from.SendMessage( "Celkem mas {0} bodu.", pm.Expy );
			item.Delete();
			
			if ( pm.Expy >= 5000000 )
			{
			ArrayList toDelete = new ArrayList();
			
			foreach ( Item itm in World.Items.Values )
			{
			if ( itm is SoutezniTruhla && !itm.Deleted )
			toDelete.Add( itm ); 
			}
			
			foreach ( Item ite in toDelete )
			ite.Delete();
			
			Account a = from.Account as Account;
			a.SetTag( "HouseLimit", "2" );
			
            from.SendMessage( 34, "NYNI MUZES POSTAVIT DVA DOMY." );
            World.Broadcast( 192, false, "Soutez craftu byla ukoncena. {0} dosahl/a skore 5 000 000 bodu.", from.RawName );
			}
			}
			// ============= RUNIC SOUTEZ END
		*/
		/*	
			public override bool OnDragDrop( Mobile from, Item dropped )
			{
			if ( dropped is BigFish )
			{
			if ( from is PlayerMobile && ((BigFish)dropped).Fisher == from )
			{
			PlayerMobile pm = ( PlayerMobile ) from;
			
			if ( m_Bonus )
			{
			from.SendMessage( "Soutez byla ukoncena. Nektery ze soutezicich jiz dosahl skore 100 000." );
			return false;
			}
			
			Effects.SendLocationParticles( EffectItem.Create( Location, Map, EffectItem.DefaultDuration ), 0x376A, 9, 32, 5024 );
			Effects.PlaySound( Location, Map, 0x364 ); //0x1FF
			
			int reward = Math.Max( (int) dropped.Weight, 1 );
			
			pm.Expy += reward;
			
			if ( pm.Expy >= 100000 )
			{
			m_Bonus = true;
			World.Broadcast( 192, false, "Rybarska soutez byla ukoncena. {0} dosahl/a skore 100 000.", from.RawName );
			
			GiftBox box = new GiftBox();
			box.Hue = 32;
			box.Name = "Darek za vitezstvi ve vanocni soutezi";
			
			box.DropItem( new BankCheck( 250000 ) );
			box.DropItem( new DamageOil() );
			box.DropItem( new DamageOil() );
			box.DropItem( new ScrollOfVirtue() );
			box.DropItem( new ScrollOfKo() );
			box.DropItem( new BaseTotemSummoner( TotemType.Healing ) );
			box.DropItem( new CechovniMince( 500 ) );
			box.DropItem( new SpendingPointsScroll( 10 ) );
			box.DropItem( new ClothingSkillScroll( SkillName.Discordance, 5.0 ) );
			box.DropItem( new ClothingSkillScroll( SkillName.Provocation, 5.0 ) );
			box.DropItem( new ClothingSkillScroll( SkillName.Peacemaking, 5.0 ) );
			box.DropItem( new ClothingSkillScroll( SkillName.Musicianship, 5.0 ) );
			box.DropItem( new JewelryPolishingSolution( 3 ) );
			
			from.BankBox.DropItem( box );
			from.SendMessage( "Odmena za vitezstvi v soutezi byla umistena do tve banky." );
			}
			
			from.SendMessage( "Ziskavas {0} bodu.", reward );
			from.SendMessage( "Celkem mas {0} bodu.", pm.Expy );
			dropped.Delete();
			return true;
            }
            else
            {
			from.SendMessage( "Tuto rybu jsi neulovil/a ty!" );
			return false;
            }
			}
			else
			{
            from.SendMessage( "Toto neni pozadovany predmet!" );
            return false;
			}
			
			return false;
			}
			
		public override bool OnDragDrop( Mobile from, Item dropped )
		{
			// TINKERING
			if ( dropped is BrilliantAmberBracelet || dropped is FireRubyBracelet || dropped is DarkSapphireBracelet || dropped is WhitePearlBracelet || 
			dropped is EcruCitrineRing || dropped is BlueDiamondRing || dropped is PerfectEmeraldRing || dropped is TurqouiseRing || 
			dropped is ResilientBracer || dropped is EssenceOfBattle || dropped is PendantOfTheMagi || dropped is NeonRing )
			{
				if ( from is PlayerMobile && from.Skills[SkillName.Tinkering].Cap < 110.0 )
				{
					PlayerMobile pm = ( PlayerMobile ) from;
					
					if ( m_Bonus )
					{
						from.SendMessage( "Soutez byla ukoncena. Nektery ze soutezicich jiz dosahl skore 2000." );
						return false;
					}
					
					Effects.SendLocationParticles( EffectItem.Create( Location, Map, EffectItem.DefaultDuration ), 0x376A, 9, 32, 5024 );
					Effects.PlaySound( Location, Map, 0x364 ); //0x1FF
					
					int reward = 1;
					
					if ( dropped is ResilientBracer || dropped is EssenceOfBattle || dropped is PendantOfTheMagi )
					reward = 3;
					
					pm.Expy += reward;
					
					if ( pm.Expy >= 2000 )
					{
						m_Bonus = true;
						World.Broadcast( 192, false, "Soutez ve vyrobe sperku byla ukoncena. {0} dosahl/a skore 2000.", from.RawName );
					}
					
					from.SendMessage( "Ziskavas {0} bodu.", reward );
					from.SendMessage( "Celkem mas {0} bodu.", pm.Expy );
					dropped.Delete();
					return true;
				}
				else
				{
					from.SendMessage( "Musis mit zakladni tinkering mensi nez 120" );
					return false;
				}
			}
			else
			{
				from.SendMessage( "Toto neni pozadovany predmet!" );
				return false;
			}
			
			return false;
		}
		/*
			public override bool OnDragDrop( Mobile from, Item dropped )
			{
			if ( dropped is HolidayBell2008 )
			{
			if ( from is PlayerMobile )
			{
			PlayerMobile pm = ( PlayerMobile ) from;
			
			if ( m_Bonus )
			{
			from.SendMessage( "Soutez ve sbirani vanocnich zvonku byla ukoncena. Nektery ze soutezicich jiz dosahl skore 50." );
			return false;
			}
			
			Effects.SendLocationParticles( EffectItem.Create( Location, Map, EffectItem.DefaultDuration ), 0x376A, 9, 32, 5024 );
			Effects.PlaySound( Location, Map, 0x100 ); //0x1FF
			
			pm.Expy++;
			
			if ( pm.Expy >= 50 )
			{
			m_Bonus = true;
			World.Broadcast( 192, false, "Soutez ve sbirani vanocnich zvonku byla ukoncena. {0} dosahl/a skore 50.", from.RawName );
			
			GiftBox box = new GiftBox();
			box.Hue = 32;
			box.Name = "Darek za vitezstvi ve vanocni soutezi";
			
			box.DropItem( new BankCheck( 250000 ) );
			box.DropItem( new DamageOil() );
			box.DropItem( new DamageOil() );
			box.DropItem( new ScrollOfVirtue() );
			box.DropItem( new ScrollOfKo() );
			box.DropItem( new BaseTotemSummoner( TotemType.Healing ) );
			box.DropItem( new CechovniMince( 500 ) );
			box.DropItem( new SpendingPointsScroll( 10 ) );
			box.DropItem( new ClothingSkillScroll( SkillName.Discordance, 5.0 ) );
			box.DropItem( new ClothingSkillScroll( SkillName.Provocation, 5.0 ) );
			box.DropItem( new ClothingSkillScroll( SkillName.Peacemaking, 5.0 ) );
			box.DropItem( new ClothingSkillScroll( SkillName.Musicianship, 5.0 ) );
			box.DropItem( new JewelryPolishingSolution( 3 ) );
			
			from.BankBox.DropItem( box );
			from.SendMessage( "Odmena za vitezstvi v soutezi byla umistena do tve banky." );
			}
			
			from.SendMessage( "Ziskavas 1 bod." );
			from.SendMessage( "Celkem mas {0} bodu.", pm.Expy );
			dropped.Delete();
			return true;
            }
            else
            {
			from.SendMessage( "Nepredvidana chyba 01" );
			return false;
            }
			}
			else
			{
            from.SendMessage( "Toto neni pozadovany predmet!" );
            return false;
			}
			
			return false;
		}*/
		
		public override void GetContextMenuEntries( Mobile from, List<ContextMenuEntry> list )
		{
		}
		
		public override void OnDoubleClick( Mobile from )
		{
			if ( (int) from.AccessLevel > (int) AccessLevel.Counselor )
			base.OnDoubleClick( from );
			else
			from.SendMessage( "Zamceno." );
		}
		
		/*public override bool CheckLift( Mobile from, Item item, ref LRReason reject )
			{
			if ( (int) from.AccessLevel > (int) AccessLevel.Player )
			return base.CheckLift( from, item, ref reject );
			else
			reject = LRReason.CannotLift;
			
			return false;
		}*/
	}
}
