  /////////////////////////////
 //////  LostSinner  /////////
/////////////////////////////

using System;
using Server;
using Server.Gumps;
using Server.Mobiles;
using Server.Network;
using Server.Items;
using Server.Spells;

namespace Server.Items
{
	
	public class MerlinsStaff2 : QuarterStaff
	{

		public override int InitMinHits{ get{ return 125; } }
		public override int InitMaxHits{ get{ return 125; } }

		[Constructable]
		public MerlinsStaff2()
		{
			ItemID = 3721;
			Name = "Merlinova hul";
			Hue = 1055;
		}

        public MerlinsStaff2(Serial serial)
            : base(serial)
		{
		}

        public override void OnDoubleClick(Mobile from)
        {
            MerlinsStaff Staff = from.FindItemOnLayer(Layer.TwoHanded) as MerlinsStaff;

            if (Parent != from)
            {
                from.SendMessage("Musis mit hul v ruce aby sla otevrit brana vedouci primo k Merlinovi");
            }
            else
            {
                Item mg2 = new MerlinsGate2();
                mg2.Location = from.Location;
                mg2.Map = from.Map;
                from.PrivateOverheadMessage( MessageType.Regular, 1153, false, "Citis silnou magickou energii spolecne vychazejici z merlinovy hole a knihy", from.NetState );
            }
        }

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}