using Auberon;
using Server.Engines.XmlSpawner2;
using Server.Items;
using Server.Mobiles;
using Server.Network;
using System;
using System.Collections;

/*
** Gives out rewards based on the PlayerMobile.Expy.
** The Gump supports Item, Mobile, and Attachment type rewards.
*/

namespace Server.Gumps
{
    public class ExpyRewardGump : Gump
    {
        private ArrayList Rewards;

        private int y_inc = 35;
        private int x_creditoffset = 350;
        private int x_pointsoffset = 410;//480;
        private int maxItemsPerPage = 9;
        private int viewpage;

        public ExpyRewardGump(Mobile m, int page) : base(20, 30)
        {
            if (!(m is PlayerMobile))
                return;

            PlayerMobile from = (PlayerMobile)m;
            from.CloseGump(typeof(ExpyRewardGump));

            // determine the gump size based on the number of rewards
            Rewards = ExpyRewards.RewardsList;

            viewpage = page;

            int height = maxItemsPerPage * y_inc + 120;
            int width = x_pointsoffset + 110;

            /*
            if(Rewards != null && Rewards.Count > 0)
            {
                height = Rewards.Count*y_inc + 120;
            }
            */

            AddBackground(0, 0, width, height, 0xDAC);

            AddHtml(40, 20, 350, 50, "Odmeny za soutezni body", false, false);

            AddLabel(350, 20, 0, String.Format("Tve body: {0}", from.Expy));

            AddButton(30, height - 35, 0xFB7, 0xFB9, 0, GumpButtonType.Reply, 0);
            AddLabel(70, height - 35, 0, "Zavrit");

            // put the page buttons in the lower right corner
            if (Rewards != null && Rewards.Count > 0)
            {
                AddLabel(width - 165, height - 35, 0, String.Format("Strana: {0}/{1}", viewpage + 1, (int)(Rewards.Count / maxItemsPerPage) + 1));

                // page up and down buttons
                AddButton(width - 55, height - 35, 0x15E0, 0x15E4, 13, GumpButtonType.Reply, 0);
                AddButton(width - 35, height - 35, 0x15E2, 0x15E6, 12, GumpButtonType.Reply, 0);
            }

            AddLabel(70, 50, 40, "Odmena");
            AddLabel(x_creditoffset, 50, 40, "Cena");
            //AddLabel(x_pointsoffset, 50, 40, "Min Points");

            // display the items with their selection buttons
            if (Rewards != null)
            {
                int y = 50;
                for (int i = 0; i < Rewards.Count; i++)
                {
                    if ((int)(i / maxItemsPerPage) != viewpage) continue;

                    ExpyRewards r = Rewards[i] as ExpyRewards;
                    if (r == null) continue;

                    y += y_inc;

                    int texthue = 0;

                    // display the item
                    if (r.Cost > from.Expy)
                    {
                        texthue = 33;
                    }
                    else
                    {
                        // add the selection button
                        AddButton(30, y, 0xFA5, 0xFA7, 1000 + i, GumpButtonType.Reply, 0);
                    }

                    // display the name
                    AddLabel(70, y + 3, texthue, r.Name);

                    // display the cost
                    AddLabel(x_creditoffset, y + 3, texthue, r.Cost.ToString());



                    // display the item
                    if (r.ItemID > 0)
                        AddItem(x_creditoffset + 60, y, r.ItemID);

                    // display the min points requirement
                    //AddLabel(x_pointsoffset, y + 3, texthue, r.MinPoints.ToString());
                }
            }
        }

        public override void OnResponse(NetState state, RelayInfo info)
        {
            if (info == null || state == null || state.Mobile == null || Rewards == null) return;

            switch (info.ButtonID)
            {
                case 12:
                    // page up
                    int nitems = 0;
                    if (Rewards != null)
                        nitems = Rewards.Count;

                    int page = viewpage + 1;
                    if (page > (int)(nitems / maxItemsPerPage))
                    {
                        page = (int)(nitems / maxItemsPerPage);
                    }
                    state.Mobile.SendGump(new ExpyRewardGump(state.Mobile, page));
                    break;
                case 13:
                    // page down
                    page = viewpage - 1;
                    if (page < 0)
                    {
                        page = 0;
                    }
                    state.Mobile.SendGump(new ExpyRewardGump(state.Mobile, page));
                    break;
                default:
                    {
                        if (info.ButtonID >= 1000)
                        {
                            int selection = info.ButtonID - 1000;
                            if (selection < Rewards.Count)
                            {
                                PlayerMobile from = (PlayerMobile)state.Mobile;

                                if (from == null)
                                    return;

                                ExpyRewards r = Rewards[selection] as ExpyRewards;

                                // check the price
                                if (from.Expy >= r.Cost)
                                {
                                    // create an instance of the reward type
                                    object o = null;

                                    try
                                    {
                                        o = Activator.CreateInstance(r.RewardType, r.RewardArgs);
                                    }
                                    catch { }

                                    bool received = true;

                                    if (o is Item)
                                    {
                                        if (o is Predmet)
                                        {
                                            ((Item)o).Delete();

                                            Item klic;

                                            switch (Utility.Random(5))
                                            {
                                                case 0:
                                                    klic = new PlayingCards();
                                                    klic.Hue = 688;
                                                    break;
                                                case 1:
                                                    klic = new PlayingCards2();
                                                    klic.Hue = 45;
                                                    break;
                                                case 2:
                                                    klic = new PlayingCards3();
                                                    klic.Hue = 280;
                                                    break;
                                                case 3:
                                                    klic = new PlayingCards4();
                                                    klic.Hue = 515;
                                                    break;
                                                default:
                                                    klic = new PlayingCards5();
                                                    klic.Hue = 1038;
                                                    break;
                                            }


                                            klic.ItemID = 8700;
                                            klic.Movable = true;
                                            klic.Name = "klic k auberonovu doupeti";
                                            klic.LootType = LootType.Blessed;
                                            klic.Weight = 2.0;
                                            XmlAttach.AttachTo(klic, new TemporaryQuestObject("ak", 86400.0));

                                            from.AddToBackpack(klic);
                                        }
                                        else if (o is PowerScroll)
                                        {
                                            ((Item)o).Delete();

                                            from.AddToBackpack(PowerScroll.CreateRandom(20, 20));
                                        }
                                        else
                                            from.AddToBackpack((Item)o);
                                    }
                                    else if (o is Mobile)
                                    {

                                        // if it is controllable then set the buyer as master.  Note this does not check for control slot limits.
                                        if (o is BaseCreature)
                                        {
                                            BaseCreature b = o as BaseCreature;
                                            b.Controlled = true;
                                            b.ControlMaster = from;
                                        }

                                        ((Mobile)o).MoveToWorld(from.Location, from.Map);

                                    }
                                    else if (o is XmlAttachment)
                                    {
                                        XmlAttachment a = o as XmlAttachment;
                                        a.Name = (a.Name == null) ? "zaExpy" : a.Name + "zaExpy";

                                        XmlAttach.AttachTo(from, a);
                                    }
                                    else
                                    {
                                        from.SendMessage(33, "unable to create {0}.", r.RewardType.Name);
                                        received = false;
                                    }

                                    // complete the transaction
                                    if (received)
                                    {
                                        // charge them
                                        from.Expy -= r.Cost;
                                        from.SendMessage("Koupil/a jsi {0} za {1} bodu.", r.Name, r.Cost);
                                    }
                                }
                                else
                                {
                                    from.SendMessage("Nemas dostatek bodu pro nakup {0}.", r.Name);
                                }
                                from.SendGump(new ExpyRewardGump(from, viewpage));
                            }
                        }
                        break;
                    }
            }
        }
    }
}
