using Server.Gumps;

/*
** ExpyRewardStone
** used to open the ExpyRewardGump that allows players to purchase rewards with their PlayerMobile.Expy.
*/

namespace Server.Items
{
    [FlipableAttribute(3803, 3804)]
    public class ExpyRewardStone : Item
    {
        [Constructable]
        public ExpyRewardStone() : base(3803)
        {
            Movable = false;
            Name = "Nakup za soutezni body";
            Hue = 1099;
        }

        public ExpyRewardStone(Serial serial) : base(serial)
        {
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)0); // version
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();
        }

        public override void OnDoubleClick(Mobile from)
        {
            if (from.InRange(GetWorldLocation(), 2))
            {
                from.SendGump(new ExpyRewardGump(from, 0));
            }
            else
            {
                from.SendLocalizedMessage(500446); // That is too far away.
            }
        }
    }
}
