using Server;
using Server.Items;
using System;
using System.Collections;

/*
** ExpyRewards
**
** this class lets you specify rewards that can be purchased for PlayerMobile.Expy.
** The items will be displayed in the ExpyRewardGump that is opened by the ExpyRewardStone
*/

namespace Auberon
{
    public class ExpyRewards
    {
        public int Cost;       // cost of the reward in credits
        public Type RewardType;   // this will be used to create an instance of the reward
        public string Name;         // used to describe the reward in the gump
        public int ItemID;     // used for display purposes
        public object[] RewardArgs; // arguments passed to the reward constructor
        public int MinPoints;   // the minimum points requirement for the reward

        private static ArrayList PointsRewardList = new ArrayList();

        public static ArrayList RewardsList { get { return PointsRewardList; } }

        public ExpyRewards(int minpoints, Type reward, string name, int cost, int id, object[] args)
        {
            RewardType = reward;
            Cost = cost;
            ItemID = id;
            Name = name;
            RewardArgs = args;
            MinPoints = minpoints;
        }

        public static void Initialize()
        {
            // these are items as rewards. Note that the args list must match a constructor for the reward type specified.
            //             PointsRewardList.Add( new ExpyRewards( 1000, typeof(PowerScroll), "105 Smithing powerscroll", 1000, 0x14F0, new object[] { SkillName.Blacksmith, 105 }));
            //             PointsRewardList.Add( new ExpyRewards( 2000, typeof(PowerScroll), "110 Smithing powerscroll", 2000, 0x14F0, new object[] { SkillName.Blacksmith, 110 }));
            //             PointsRewardList.Add( new ExpyRewards( 4000, typeof(PowerScroll), "115 Smithing powerscroll", 4000, 0x14F0, new object[] { SkillName.Blacksmith, 115 }));
            //             PointsRewardList.Add( new ExpyRewards( 500, typeof(AncientSmithyHammer), "+20 Ancient Smithy Hammer, 50 uses", 500, 0x13E4, new object[] { 20, 50 }));
            //             PointsRewardList.Add( new ExpyRewards( 200, typeof(ColoredAnvil), "Colored Anvil", 400, 0xFAF, null ));
            //             PointsRewardList.Add( new ExpyRewards( 100, typeof(PowderOfTemperament), "Powder Of Temperament, 10 uses", 300, 4102, new object[] { 10 }));
            //             PointsRewardList.Add( new ExpyRewards( 100, typeof(LeatherGlovesOfMining), "+20 Leather Gloves Of Mining", 200, 0x13c6, new object[] { 20 }));

            // this is an example of adding a mobile as a reward
            //             PointsRewardList.Add( new ExpyRewards( 0, typeof(RidableLlama),"Ridable Llama", 1, 0x20f6, null));

            PointsRewardList.Add(new ExpyRewards(0, typeof(Predmet), "Nahodny klic k auberonovu doupeti", 150, 8700, null));
            PointsRewardList.Add(new ExpyRewards(0, typeof(StatScroll), "Stat scroll +1", 30, 5360, new object[] { 1 }));
            PointsRewardList.Add(new ExpyRewards(0, typeof(RandomLevelClothingBag), "Random level clothing bag", 20, 3702, new object[] { 1 }));
            PointsRewardList.Add(new ExpyRewards(0, typeof(ExaltedLevelUpScroll), "+10 scroll of leveling", 20, 5360, null));
            PointsRewardList.Add(new ExpyRewards(0, typeof(SlzaAuberonu), "Slza auberonu", 10, 12629, null));
            PointsRewardList.Add(new ExpyRewards(0, typeof(MagicScroll), "Magic scroll +1", 15, 5360, new object[] { 1 }));
            PointsRewardList.Add(new ExpyRewards(0, typeof(MagicScroll), "Magic spellbook scroll +1", 25, 5360, new object[] { 1, true }));
            PointsRewardList.Add(new ExpyRewards(0, typeof(MagicalWire), "Magical wire +1", 15, 6263, new object[] { 1 }));
            PointsRewardList.Add(new ExpyRewards(0, typeof(MesicniKamen), "Mesicni kamen x3", 10, 3979, new object[] { 3 }));
            PointsRewardList.Add(new ExpyRewards(0, typeof(CechovniMince), "Cechovni mince x10", 25, 3824, new object[] { 10 }));
            PointsRewardList.Add(new ExpyRewards(0, typeof(Tokens), "Stribrne mince x10", 20, 3824, new object[] { 10 }));
            PointsRewardList.Add(new ExpyRewards(0, typeof(PSToken), "Power scroll token x5", 30, 0x1422, new object[] { 5 }));
            PointsRewardList.Add(new ExpyRewards(0, typeof(RandomRunicToolBag), "Nahodny runic tool", 10, 0xE76, new object[] { 1 }));
            PointsRewardList.Add(new ExpyRewards(0, typeof(SkillBall), "Skill ball +5", 15, 6249, new object[] { 5.0 }));
            PointsRewardList.Add(new ExpyRewards(0, typeof(Xanthos.Evo.RandomDustBag), "Nahodny evolution dust x500", 40, 0x26B8, new object[] { 500 }));
            PointsRewardList.Add(new ExpyRewards(0, typeof(PowerScroll), "Nahodny power scroll 120", 40, 5360, new object[] { PowerScroll.RandomSkill(), 120.0 }));
            PointsRewardList.Add(new ExpyRewards(0, typeof(ArtifactFragment), "Artifact fragmnent", 10, 2428, new object[] { 1 }));
            PointsRewardList.Add(new ExpyRewards(0, typeof(GrobusFur), "Orcish fetish", 20, 9646, new object[] { true }));
            PointsRewardList.Add(new ExpyRewards(0, typeof(CharmOfLuck), "Charm of luck", 50, 9908, new object[] { 1 }));
            PointsRewardList.Add(new ExpyRewards(50, typeof(Server.Engines.XmlSpawner2.XmlStr), "+20 Strength na 12 hodin", 30, 0, new object[] { 20, 43200.0 }));
            PointsRewardList.Add(new ExpyRewards(50, typeof(Server.Engines.XmlSpawner2.XmlDex), "+20 Dexterity na 12 hodin", 30, 0, new object[] { 20, 43200.0 }));
            PointsRewardList.Add(new ExpyRewards(50, typeof(Server.Engines.XmlSpawner2.XmlInt), "+20 Inteligence na 12 hodin", 30, 0, new object[] { 20, 43200.0 }));

            //"Stat Scroll +1", 30
            //"Random level clothing bag", 20
            //"+10 scroll of Leveling", 20
            //"Slza auberonu", 10
            //"Magic Scroll +1", 15
            //"Magical Wire +1", 15
            //"Mesicni kamen x3", 10
            //"Cechovni mince x10", 25
            //"Stribro x10", 20
            //"PStoken x5",30
            //"random runic x1",10
            //"skillball +5",15
            //"random dust x500",40
            //"random power scroll 120", 40
            //"Artifact fragment x1", 10
            //"Orcish fetish x1", 20
            //"Charm of luck x1", 50
            //"+30 hp na 12h", 30
            //"+20 STR na 12h", 30

            // PointsRewardList.Add( new ExpyRewards( 50, typeof(XmlStr), "+20 Strength for 1 day", 20, 0, new object[] { 20, 86400.0 }));
            // PointsRewardList.Add( new ExpyRewards( 50, typeof(XmlDex), "+20 Dexterity for 1 day", 20, 0, new object[] { 20, 86400.0 }));
            // PointsRewardList.Add( new ExpyRewards( 50, typeof(XmlInt), "+20 Inteligence for 1 day", 20, 0, new object[] { 20, 86400.0 }));
        }

    }
}
