using System;
using Server;
using Server.Items;
using Server.Gumps;
using Server.Network;
using Server.Commands;
using Server.Mobiles;
using System.Collections;
using System.Collections.Generic;

namespace Server.Gumps
{
	public class SoutezeBoardGump : Gump
	{
		public static void Initialize()
		{
			CommandSystem.Register("Souteze", AccessLevel.Player, new CommandEventHandler(SoutezeBoardGump_OnCommand));
		}

		[Usage("Souteze")]
		[Description("Zobrazi vysledkove listiny soutezi.")]
		public static void SoutezeBoardGump_OnCommand(CommandEventArgs e)
		{
			if (e.Mobile.HasGump(typeof(SoutezeBoardGump)))
				e.Mobile.CloseGump(typeof(SoutezeBoardGump));
			e.Mobile.SendGump(new SoutezeBoardGump());
		}

		public SoutezeBoardGump() : base(100, 100)
		{
			this.Closable = true;
			this.Disposable = true;
			this.Dragable = true;
			this.Resizable = false;

			int pocetZubu = 0;
			int pocetHracu = 0;

			List<Mobile> mobs = new List<Mobile>(World.Mobiles.Values);
			ArrayList ZubyArray = new ArrayList();

			foreach (Mobile m in mobs)
			{
				if (m is PlayerMobile && SoutezeLog.ZubyLastWinner != m)
				{
					PlayerMobile pm = (PlayerMobile) m;

					if (pm.Zuby != null && pm.Zuby > 0)
					{
						pocetZubu += pm.Zuby;
						pocetHracu++;
						ZubyArray.Add(pm);
					}
				}
			}

			string zuby1 = "Zatim nikdo nenasel zadny auberonuv zub";
			string zuby2 = String.Format("<basefont color=black>Konec kola: {0:D}<br>{1} hracu nalezlo {2} zubu", SoutezeLog.ZubyEndRound, pocetHracu, pocetZubu);

			// 			if ( SoutezeLog.ZubyLastWinner != null )
			// 			   zuby2 += String.Format( "<br>Posledni vitez: {0}<br>", SoutezeLog.ZubyLastWinner.RawName );

			zuby2 += String.Format("<br>Vysledky posledniho kola:<br>{0}<br>", SoutezeLog.ZubyString);

			if (ZubyArray != null && ZubyArray.Count > 0)
			{
				ZubyArray.Sort(new SoutezeLog.ZubyListAmountSorter());
				int count = ZubyArray.Count > 19 ? 20 : ZubyArray.Count;
				zuby1 = "";

				for (int i = 0; i < count; i++)
				{
					if (ZubyArray[i] == null || !(ZubyArray[i] is PlayerMobile)) { continue; }
					else
					{
						PlayerMobile pm = (PlayerMobile) ZubyArray[i];

						zuby1 += String.Format("{0}. {1} - {2} zubu<br>", i+1, pm.RawName, pm.Zuby);
					}
				}
			}

			ZubyArray.Clear();

			//CRAFT
			ArrayList scorelist = CraftLog.GetSortedData();
			string craft = "";

			if (scorelist == null || scorelist.Count < 1)
				craft = "Zatim nikdo neziskal zadne body<br>";
			else
			{
				int count = 1;

				foreach (KeyValuePair<Mobile, int> kv in scorelist)
				{
					if (kv.Value > 0)
					{
						craft += String.Format("{0}. {1} - {2} bodu<br>", count, ((Mobile)kv.Key).RawName, kv.Value);
						count++;
					}
				}
			}
			
			craft += String.Format("<br>Posledni vitez: {0}", (CraftLog.LastWinner != null) ? CraftLog.LastWinner.RawName : "---");
			craft += "<br>Konec kola: 6 000 000 bodu";

			//Fishing
			scorelist = FishingLog.GetSortedData();
			string fish = "";

			if (scorelist == null || scorelist.Count < 1)
				fish = "Zatim nikdo neziskal zadne body<br>";
			else
			{
				int count = 1;

				foreach (KeyValuePair<Mobile, int> kv in scorelist)
				{
					if (kv.Value > 0)
					{
						fish += String.Format("{0}. {1} - {2} bodu<br>", count, ((Mobile)kv.Key).RawName, kv.Value);
						count++;
					}
				}
			}
			
			fish += String.Format("<br>Posledni vitez: {0}", (FishingLog.LastWinner != null) ? FishingLog.LastWinner.RawName : "---");
			fish += "<br>Konec kola: 20 000 bodu";
			
			string[] uspechy = Misc.Uspechy.GetHTMLList();

			AddPage(0);
			this.AddBackground(60, 73, 690, 475, 9260);
			this.AddImage(140, 40, 1417);
			this.AddImage(360, 40, 1417);
			this.AddImage(539, 40, 1417);
			this.AddImage(632, 40, 1417);
			this.AddImage(150, 50, 5561);
			this.AddImage(370, 50, 5547);
			this.AddImage(549, 50, 5559);
			this.AddImage(642, 50, 5565);

			this.AddLabel(97, 120, 403, String.Format("Auberonovy zuby - {0}. kolo", SoutezeLog.ZubyRoundNo));
			this.AddLabel(367, 120, 403, @"Uspesnost");
			this.AddLabel(326, 318, 403, @"Uspesnost Underworld");
			this.AddLabel(570, 120, 403, @"Soutez craftu");
			this.AddLabel(570, 318, 403, @"Soutez rybaru");

			this.AddHtml(85, 145, 210, 240, zuby1, (bool)true, (bool)true);
			this.AddHtml(90, 395, 210, 110, zuby2 + "</basefont>", (bool)false, (bool)true);
			this.AddHtml(301, 145, 210, 170, uspechy[0], (bool)true, (bool)true);
			this.AddHtml(301, 338, 210, 170, uspechy[1], (bool)true, (bool)true);
			this.AddHtml(520, 145, 210, 170, craft, (bool)true, (bool)true);
			this.AddHtml(520, 338, 210, 170, fish, (bool)true, (bool)true);

			this.AddButton(90, 510, 4005, 4007, 1, GumpButtonType.Reply, 0);
			this.AddLabel(130, 510, 403, @"Kompendium - Souteze (otevrit v prohlizeci)");
		}

		public override void OnResponse(NetState state, RelayInfo info)
		{
			switch (info.ButtonID)
			{
				case 0: // close
				{
					break;
				}

				case 1:
				{
					state.Mobile.LaunchBrowser("http://auberon.stranky.org/kompendium.php?c=681");
					break;
				}
			}
		}
	}
}

namespace Server.Items
{
	[Flipable(0x1E5E, 0x1E5F)]
	public class SoutezeBoard : Item
	{
		[Constructable]
		public SoutezeBoard() : base(0x1E5E)
		{
			Movable = false;
			Hue = 51;
			Name = "Vysledkove listiny soutezi";
		}

		public override void OnDoubleClick(Mobile from)
		{
			if ((!from.InRange(GetWorldLocation(), 3) || !from.InLOS(this)) && from.AccessLevel == AccessLevel.Player)
			{
				from.SendLocalizedMessage(500446); // That is too far away.
				return;
			}

			from.CloseGump(typeof(SoutezeBoardGump));
			from.SendGump(new SoutezeBoardGump());
		}

		public SoutezeBoard(Serial serial) : base(serial)
		{
		}

		public override void Serialize(GenericWriter writer)
		{
			base.Serialize(writer);
			writer.Write((int)0); // version
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);
			int version = reader.ReadInt();
		}
	}
}