using System;
using Server;
using System.Collections;
using System.Collections.Generic;
using Server.Gumps;
using Server.Mobiles;
using Server.Network;
using System.IO;

namespace Server.Items
{
	public class SoutezeLog
	{
		public const string SAVE_PATH = @"Saves";
		public const string FILENAME = "Souteze.bin";

		private static Mobile m_ZubyLastWinner;
		private static DateTime m_ZubyEndRound;
		private static int m_ZubyRoundNo;
		private static string m_ZubyString;

		public static Mobile ZubyLastWinner { get { return m_ZubyLastWinner; } set { m_ZubyLastWinner = value; } }
		public static DateTime ZubyEndRound { get { return m_ZubyEndRound; } set { m_ZubyEndRound = value; } }
		public static int ZubyRoundNo { get { return m_ZubyRoundNo; } set { m_ZubyRoundNo = value; } }
		public static string ZubyString { get { return m_ZubyString; } set { m_ZubyString = value; } }
		
		public static bool IsAbilityImmune( Mobile from )
		{
			if (m_ZubyLastWinner == from)
				return true;
				
			if (from.HeadArmor is LevelHuntersHeaddress)
			{
				if (((LevelHuntersHeaddress)from.HeadArmor).Bonus >= 1000)
				{
					((LevelHuntersHeaddress)from.HeadArmor).Bonus -= 1000;
					from.LocalOverheadMessage( MessageType.Regular, 0x3B2, false, "*Hunter's Headdress te ochranil*" );
					return true;
				}
				else
				{
					from.SendMessage( "[Hunter's Headdress]: Nizky pocet nabiti - {0}", ((LevelHuntersHeaddress)from.HeadArmor).Bonus );
					return false;
				}
			}
			
			return false;
		}

		public class ZubyListAmountSorter : IComparer
		{
			public ZubyListAmountSorter() : base()
			{
			}

			public int Compare(object x, object y)
			{
				if (x == null || y == null || x == y || !(x is PlayerMobile) || !(y is PlayerMobile)) return 0;
				if (((PlayerMobile)x).Zuby == ((PlayerMobile)y).Zuby)
				{
					return ((Mobile)x).RawName.CompareTo(((Mobile)y).RawName);
				}

				return ((((PlayerMobile)x).Zuby > ((PlayerMobile)y).Zuby) ? -1 : 1);
			}
		}

		private static void ZubyEnd()
		{
			if (m_ZubyEndRound < DateTime.Now)
			{
				ArrayList ZubyArray = new ArrayList();
				List<Mobile> mobs = new List<Mobile>(World.Mobiles.Values);

				foreach (Mobile m in mobs)
				{
					if (m is PlayerMobile && m_ZubyLastWinner != m)
					{
						if (((PlayerMobile)m).Zuby > 0)
							ZubyArray.Add(m);
					}
				}

				if (ZubyArray != null && ZubyArray.Count > 0)
				{
					ZubyArray.Sort(new ZubyListAmountSorter());
					m_ZubyString = "";

					for (int i = 0; i < ZubyArray.Count; i++)
					{
						if (ZubyArray[i] == null || !(ZubyArray[i] is PlayerMobile)) { continue; }
						else
						{
							PlayerMobile pm = (PlayerMobile) ZubyArray[i];

							if (i == 0)
							{
								World.Broadcast(192, false, "Prave zacalo nove kolo souteze ve sbirani auberonovych zubu. (Vitez: {0})", pm.RawName);

								if (m_ZubyLastWinner != null && m_ZubyLastWinner is PlayerMobile)
									((PlayerMobile)m_ZubyLastWinner).Zuby = 0;

								m_ZubyLastWinner = (Mobile) pm;
								m_ZubyString += String.Format("1. {0} - {1} zubu<br>", pm.RawName, pm.Zuby);

								if (pm.BankBox != null)
								{
									pm.BankBox.DropItem(new CechovniMince(5000));

									Item item = new Predmet();
									item.Name = String.Format("Za vitezstvi v {0}. kole souteze Auberonovy Zuby {1:D}", m_ZubyRoundNo, DateTime.Now);
									item.BlessedFor = pm;
									item.ItemID = Utility.RandomMinMax(0x2AAB, 0x2AB7);
									pm.BankBox.DropItem(item);
								}

								pm.StatCap += 5;
							}
							else if (i == 1)
							{
								m_ZubyString += String.Format("2. {0} - {1} zubu<br>", pm.RawName, pm.Zuby);

								if (pm.BankBox != null)
								{
									pm.BankBox.DropItem(new CechovniMince(3000));
								}
							}
							else if (i == 2)
							{
								m_ZubyString += String.Format("3. {0} - {1} zubu<br>", pm.RawName, pm.Zuby);

								if (pm.BankBox != null)
								{
									pm.BankBox.DropItem(new CechovniMince(1000));
								}
							}

							pm.Zuby = 0;
						}
					}

					m_ZubyEndRound = DateTime.Now + TimeSpan.FromDays(90.0);//TimeSpan.FromDays( 90.0 );
					m_ZubyRoundNo++;
				}
			}
		}

		public static void Configure()
		{
			EventSink.WorldLoad += new WorldLoadEventHandler(OnLoad);
			EventSink.WorldSave += new WorldSaveEventHandler(OnSave);
		}

		private static void OnLoad()
		{
			//don't load the file if it don't exist!
			if(File.Exists(Path.Combine(SAVE_PATH, FILENAME)))
			{
				using(FileStream bin = new FileStream(Path.Combine(SAVE_PATH, FILENAME), FileMode.Open, FileAccess.Read, FileShare.Read))
				{
					GenericReader reader = new BinaryFileReader(new BinaryReader(bin));

					int version = reader.ReadInt();

					switch (version)
					{
						case 1:
						{
							goto case 0;
						}

						case 0:
						{
							m_ZubyLastWinner = reader.ReadMobile();
							m_ZubyEndRound = reader.ReadDateTime();
							m_ZubyRoundNo = reader.ReadInt();
							m_ZubyString = reader.ReadString();
							break;
						}
					}

					reader.End();
				}
			}

			if (m_ZubyEndRound == null || m_ZubyEndRound == DateTime.MinValue)
				m_ZubyEndRound = DateTime.Now + TimeSpan.FromDays(70.0);//TimeSpan.FromDays( 90.0 );

			if (m_ZubyRoundNo < 30)
				m_ZubyRoundNo = 30;

			if (String.IsNullOrEmpty(m_ZubyString))
				m_ZubyString = "Data nejsou k dispozici";
		}

		private static void OnSave(WorldSaveEventArgs e)
		{
			if(!Directory.Exists(SAVE_PATH))
			{
				Directory.CreateDirectory(SAVE_PATH);
			}

			GenericWriter writer = new BinaryFileWriter(Path.Combine(SAVE_PATH, FILENAME), true);

			writer.Write(0);

			writer.Write(m_ZubyLastWinner);
			writer.Write(m_ZubyEndRound);
			writer.Write(m_ZubyRoundNo);
			writer.Write(m_ZubyString);

			writer.Close();

			ZubyEnd();
		}

		public SoutezeLog()
		{
		}
	}
}