/////////////////
///LostSinner///
///////////////

using Server;
using System;
using Server.Items;
using System.Collections;
using Server.Mobiles;
using Server.Misc;

namespace Server.Mobiles
{
	//[CorpseName( "an Vampiriac steed corpse" )]
	public class VampiriacSteed : BaseWarHorse
	{
		[Constructable]
        public VampiriacSteed()
            : base(0x78, 0x3EAF, AIType.AI_Mage, FightMode.Closest, 10, 1, 0.2, 0.4)
		{
			
			BaseSoundID = 0xA8;

			SetStr( 450, 750 );
			SetDex( 300, 360 );
			SetInt( 360, 600 );

			SetHits( 800, 1050 );
			SetMana( 120, 160 );
			SetStam( 140, 170 );

			SetDamage( 15, 20 );

			SetDamageType( ResistanceType.Physical, 50 );
			SetDamageType( ResistanceType.Fire, 50 );
			
			SetResistance( ResistanceType.Physical, 49, 59 );
			SetResistance( ResistanceType.Poison, 49, 59 );
			SetResistance( ResistanceType.Energy, 10, 20 );
			SetResistance( ResistanceType.Cold, 70, 70 );
			SetResistance( ResistanceType.Fire, 40, 42 );
			

			SetSkill( SkillName.MagicResist, 50.0, 50.0 );
			SetSkill( SkillName.Tactics, 50.0, 50.0 );
			SetSkill( SkillName.Wrestling, 80.0, 95.0 );
			SetSkill( SkillName.Poisoning, 55.0, 80.0 );
			SetSkill( SkillName.Magery, 90.0, 100.0 );
			SetSkill( SkillName.EvalInt, 85.0, 90.0 );
			SetSkill( SkillName.Meditation, 65.0, 75.0 );

			Fame = 800;
			Karma = -1500;

			Tamable = true;
			ControlSlots = 3;
			MinTameSkill = 105.1;
			
			Name = "an vampiraic steed";
			Hue = 1157;
			
			VirtualArmor = 10;
		}
		public override bool AutoDispel{ get{ return true; } }
		public override bool Unprovokable{ get{ return true; } }
		public override Poison PoisonImmune{ get{ return Poison.Deadly; } }
		public override FoodType FavoriteFood{ get{ return FoodType.Meat; } }
		public override Poison HitPoison{ get{ return Utility.RandomBool() ? Poison.Deadly : Poison.Greater; } }
		public override double HitPoisonChance{ get{ return 0.2; } }
		public override PackInstinct PackInstinct{ get{ return PackInstinct.Equine; } }
		
		// TODO: "This creature can breath chaos.

		public void DrainLife( Mobile m )
		{
			if ( m != null && m != this )
			{
				DoHarmful( m );

				m.FixedParticles( 0x374A, 10, 15, 5013, 0x496, 0, EffectLayer.Waist );
				m.PlaySound( 0x231 );

				int toDrain = Utility.RandomMinMax( 50, 100 );

				Hits += toDrain;
				m.Damage( toDrain, this );
			}
		}

		public override void OnGaveMeleeAttack( Mobile defender )
		{
			base.OnGaveMeleeAttack( defender );

			if ( 0.15 >= Utility.RandomDouble() )
				DrainLife( defender );
		}
// 
// 		public override void OnGotMeleeAttack( Mobile attacker )
// 		{
// 			base.OnGotMeleeAttack( attacker );
// 
// 			if ( 0.33 >= Utility.RandomDouble() )
// 				DrainLife();
// 		}

		public VampiriacSteed( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}