// LootData.cs
// Author: Oak (ssalter)
// Version: 1.0
// Requirements: Runuo 2.0, XmlSpawner2
// Server Tested with: 2.0 build 64
// Revision Date: 7/1/2006
// Purpose: Player can type 'grab options' to get a gump and select what types of items they want to transfer
// to their lootbag when using the 'claim' command. Uses XMLAttachment for loot options

using System;
using Server;
using Server.Items;
using Server.Network;
using Server.Mobiles;

namespace Server.Engines.XmlSpawner2
{
	public class VampireQuest : XmlAttachment
	{
		private DateTime m_NextRepeat;

		[CommandProperty( AccessLevel.GameMaster )]
		public DateTime NextRepeat { get { return m_NextRepeat; } set { m_NextRepeat  = value; } }
		
		public VampireQuest(ASerial serial) : base(serial)
		{
		}

		[Attachable]
		public VampireQuest( DateTime repeat )
		{
		    m_NextRepeat = repeat;
		    Name = "Vamp Quest";
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize(writer);

			writer.Write( (int) 0 );
			// version 0
			writer.Write(m_NextRepeat);
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);
			// version 0
			int version = reader.ReadInt();
			m_NextRepeat = reader.ReadDateTime();
		}
	}
}
