using System;
using Server.Misc;
using Server.Gumps;
using Server.Mobiles;
using Server.Commands;
using Server.Targeting;

namespace Server.Commands
{
   public class CSCommand
   {
     public static void Initialize()
     {
  	      CommandSystem.Register( "cs", AccessLevel.GameMaster, new CommandEventHandler( CS_OnCommand ) );
     }
  
     public static void Register( string command, AccessLevel access, CommandEventHandler handler )
     {
  	      CommandSystem.Register( command, access, handler );
     }
  
  	  [Usage( "cs" )] 
     [Description( "nastavi pocet bodu v craft soutezi")] 
     public static void CS_OnCommand( CommandEventArgs e )
     {
         string Message = e.ArgString;
			Message = Message.Trim();
			int cislo = 0;
			
         try
         {
            cislo = Convert.ToInt32(Message, 10);
         }
         catch
         {
			   e.Mobile.SendMessage( "Musis napsat cislo s poctem bodu (.cs 100)" );
            return;
         }
         
         if ( cislo < 0 )
            cislo = 0;
         else if ( cislo  >= 6000000 )
            cislo = 5999999;
			
         e.Mobile.SendMessage( "Vyber hrace kteremu chces nastavit body v craft soutezi" );
         e.Mobile.Target = new InternalTarget( cislo );
     }
     
		private class InternalTarget : Target
		{
    		private int m_Message;
    		
			public InternalTarget( int msg ) : base( 20, true, TargetFlags.None )
			{
			   m_Message = msg;
			}

			protected override void OnTarget( Mobile from, object targeted )
			{
				if ( targeted is PlayerMobile )
				{
               from.SendMessage( "Body v craft soutezi nastaveny na {0}", m_Message );
					Server.Items.CraftLog.Record( m_Message, (Mobile) targeted, false );
            }
            else
               from.SendMessage( "Musis vybrat hrace" );               
			}
		}
   }
}