using System;
using Server.Misc;
using Server.Gumps;
using Server.Mobiles;
using Server.Commands;
using Server.Targeting;

namespace Server.Commands
{
   public class FSCommand
   {
     public static void Initialize()
     {
  	      CommandSystem.Register( "fs", AccessLevel.GameMaster, new CommandEventHandler( FS_OnCommand ) );
     }
  
     public static void Register( string command, AccessLevel access, CommandEventHandler handler )
     {
  	      CommandSystem.Register( command, access, handler );
     }
  
  	  [Usage( "fs" )] 
     [Description( "nastavi pocet bodu v fishing soutezi")] 
     public static void FS_OnCommand( CommandEventArgs e )
     {
         string Message = e.ArgString;
			Message = Message.Trim();
			int cislo = 0;
			
         try
         {
            cislo = Convert.ToInt32(Message, 10);
         }
         catch
         {
			   e.Mobile.SendMessage( "Musis napsat cislo s poctem bodu (.fs 100)" );
            return;
         }
         
         if ( cislo < 0 )
            cislo = 0;
         else if ( cislo  >= 20000 )
            cislo = 19999;
			
         e.Mobile.SendMessage( "Vyber hrace kteremu chces nastavit body v rybarske soutezi" );
         e.Mobile.Target = new InternalTarget( cislo );
     }
     
		private class InternalTarget : Target
		{
    		private int m_Message;
    		
			public InternalTarget( int msg ) : base( 20, true, TargetFlags.None )
			{
			   m_Message = msg;
			}

			protected override void OnTarget( Mobile from, object targeted )
			{
				if ( targeted is PlayerMobile )
				{
               from.SendMessage( "Body v rybarske soutezi nastaveny na {0}", m_Message );
					Server.Items.FishingLog.Record( m_Message, (Mobile) targeted, false );
            }
            else
               from.SendMessage( "Musis vybrat hrace" );               
			}
		}
   }
}