using System;
using Server.Misc;
using Server.Gumps;
using Server.Mobiles;
using Server.Commands;
using Server.Targeting;

namespace Server.Commands
{
   public class GetInfo
   {
     public static void Initialize()
     {
  	      CommandSystem.Register( "getinfo", AccessLevel.Counselor, new CommandEventHandler( GetInfo_OnCommand ) );
     }
  
     public static void Register( string command, AccessLevel access, CommandEventHandler handler )
     {
  	      CommandSystem.Register( command, access, handler );
     }
  
  	  [Usage( "GetInfo" )] 
     [Description( "Info gump zamereneho hrace")] 
     public static void GetInfo_OnCommand( CommandEventArgs e )
     {
         e.Mobile.SendMessage( "Vyber hrace pro zobrazeni detailnich informaci" );
         e.Mobile.Target = new InternalTarget();
     }
     
		private class InternalTarget : Target
		{

			public InternalTarget() : base( 20, true, TargetFlags.None )
			{
			}

			protected override void OnTarget( Mobile from, object targeted )
			{
				if ( targeted is PlayerMobile )
				{
			      if( from.HasGump( typeof(EYNTK) ) )
				     from.CloseGump( typeof(EYNTK) );
         
               from.SendGump(new EYNTK( (Mobile) targeted, from ));      
            }
            else
               from.SendMessage( "Musis vybrat hrace" );               
			}
		}
   }
}