using System;
using Server.Misc;
using Server.Mobiles;
using Server.Commands;
using Server.Targeting;

namespace Server.Commands
{
   public class JailPetCommand
   {
     public static void Initialize()
     {
  	      CommandSystem.Register( "JailPet", AccessLevel.GameMaster, new CommandEventHandler( JailPet_OnCommand ) );
     }
  
     public static void Register( string command, AccessLevel access, CommandEventHandler handler )
     {
  	      CommandSystem.Register( command, access, handler );
     }
  
  	  [Usage( "JailPet" )] 
     [Description( "Posle peta na GA do ohrady 5381 1086 0")] 
     public static void JailPet_OnCommand( CommandEventArgs e )
     {
         e.Mobile.SendMessage( "Ktereho peta chces poslat do ohrady na GA?" );
         e.Mobile.Target = new InternalTarget();
     }
     
		private class InternalTarget : Target
		{

			public InternalTarget() : base( 20, true, TargetFlags.None )
			{
			}

			protected override void OnTarget( Mobile from, object targeted )
			{
				if ( targeted is BaseCreature )
				{
			      BaseCreature bc = targeted as BaseCreature;
               
               if ( bc.Controlled )
               {
					    bc.MoveToWorld( new Point3D( 5381, 1086, 0 ), Map.Trammel );
					    from.SendMessage( "Pet byl poslan do ohrady na GA (5381 1086 0)" );
               }
               else
                  from.SendMessage( "Toto zvire neni nikym ovladane" );
            }
            else
               from.SendMessage( "Musis vybrat ovladaneho peta" );               
			}
		}
   }
}