using System;
using Server.Misc;
using Server.Gumps;
using Server.Mobiles;
using Server.Commands;
using Server.Targeting;

namespace Server.Commands
{
   public class PlayerEmoteCommand
   {
     public static void Initialize()
     {
  	      CommandSystem.Register( "pe", AccessLevel.GameMaster, new CommandEventHandler( PlayerEmote_OnCommand ) );
     }
  
     public static void Register( string command, AccessLevel access, CommandEventHandler handler )
     {
  	      CommandSystem.Register( command, access, handler );
     }
  
  	  [Usage( "pe" )] 
     [Description( "emote npc")] 
     public static void PlayerEmote_OnCommand( CommandEventArgs e )
     {
         string Message = e.ArgString;
			Message = Message.Trim();
			
			if ( Message.Length == 0 )
			{
			   e.Mobile.SendMessage( "Musis napsat text emote (.pe text zpravy)" );
			}
			else
			{
            e.Mobile.SendMessage( "Vyber hrace nebo npc u ktereho chces zobrazit emote" );
            e.Mobile.Target = new InternalTarget( "*" + Message + "*" );
         }
     }
     
		private class InternalTarget : Target
		{
    		private string m_Message;
    		
			public InternalTarget( string msg ) : base( 20, true, TargetFlags.None )
			{
			   m_Message = msg;
			}

			protected override void OnTarget( Mobile from, object targeted )
			{
				if ( targeted is Mobile )
				{
			      Mobile m = (Mobile) targeted;         
// 					m.LocalOverheadMessage( Network.MessageType.Emote, m.SpeechHue, true, m_Message );
// 					m.NonlocalOverheadMessage( Network.MessageType.Emote, m.SpeechHue, true, m_Message );
					m.Emote( m_Message );
            }
            else
               from.SendMessage( "Musis vybrat hrace nebo NPC" );               
			}
		}
   }
}