using System;
using Server.Misc;
using Server.Gumps;
using Server.Mobiles;
using Server.Commands;
using Server.Targeting;

namespace Server.Commands
{
   public class PlayerSayCommand
   {
     public static void Initialize()
     {
  	      CommandSystem.Register( "ps", AccessLevel.GameMaster, new CommandEventHandler( PlayerSay_OnCommand ) );
     }
  
     public static void Register( string command, AccessLevel access, CommandEventHandler handler )
     {
  	      CommandSystem.Register( command, access, handler );
     }
  
  	  [Usage( "ps" )] 
     [Description( "say text to npc")] 
     public static void PlayerSay_OnCommand( CommandEventArgs e )
     {
         string Message = e.ArgString;
			Message = Message.Trim();
			
			if ( Message.Length == 0 )
			{
			   e.Mobile.SendMessage( "Musis napsat text (.pe text zpravy)" );
			}
			else
			{
            e.Mobile.SendMessage( "Vyber hrace nebo npc ktere, ma rict dany text" );
            e.Mobile.Target = new InternalTarget( Message );
         }
     }
     
		private class InternalTarget : Target
		{
    		private string m_Message;
    		
			public InternalTarget( string msg ) : base( 20, true, TargetFlags.None )
			{
			   m_Message = msg;
			}

			protected override void OnTarget( Mobile from, object targeted )
			{
				if ( targeted is Mobile )
				{
			      Mobile m = (Mobile) targeted;         
					m.Say( m_Message );
            }
            else
               from.SendMessage( "Musis vybrat hrace nebo NPC" );               
			}
		}
   }
}