using System;
using Server.Misc;
using Server.Gumps;
using Server.Mobiles;
using Server.Commands;
using Server.Targeting;

namespace Server.Commands
{
   public class RefreshCommand
   {
     public static void Initialize()
     {
  	      CommandSystem.Register( "r", AccessLevel.GameMaster, new CommandEventHandler( Refresh_OnCommand ) );
     }
  
     public static void Register( string command, AccessLevel access, CommandEventHandler handler )
     {
  	      CommandSystem.Register( command, access, handler );
     }
  
  	  [Usage( "r" )] 
     [Description( "obnovi staminu, manu a zivoty zamerenemu cili")] 
     public static void Refresh_OnCommand( CommandEventArgs e )
     {
         e.Mobile.SendMessage( "Vyber hrace nebo NPC pro vyleceni" );
         e.Mobile.Target = new InternalTarget();
     }
     
		private class InternalTarget : Target
		{

			public InternalTarget() : base( 20, true, TargetFlags.None )
			{
			}

			protected override void OnTarget( Mobile from, object targeted )
			{
				if ( targeted is Mobile )
				{
			      Mobile m = (Mobile) targeted;
         
					m.Poison = null;
					m.Hits = m.HitsMax;
					m.Mana = m.ManaMax;
					m.Stam = m.StamMax;
					from.SendMessage( "Cil byl vylecen" );
            }
            else
               from.SendMessage( "Musis vybrat hrace nebo NPC" );               
			}
		}
   }
}