using System;
using Server;
using Server.Mobiles;
using Server.Gumps;
using System.Collections;
using System.Collections.Generic;

namespace Server.Commands
{
	public class SmazatExpy
	{
		public static void Initialize()
		{
			CommandSystem.Register( "SmazatExpy", AccessLevel.GameMaster, new CommandEventHandler( SmazatExpy_OnCommand ) );
		}
		
		[Usage( "SmazatExpy" )]
		[Description( "Vynuluje polozku Expy u vsech hracu." )]
		private static void SmazatExpy_OnCommand( CommandEventArgs e )
		{
			e.Mobile.SendGump( new ConfirmSmazatExpyGump() );
         e.Mobile.SendMessage( 0x35, "Potvrd vynulovani polozky Expy u vsech hracu!" );
		}
		
		private class ConfirmSmazatExpyGump : BaseConfirmGump
		{
			public ConfirmSmazatExpyGump() : base()
			{
			}
			
			public override void Confirm( Mobile from )
			{
    			int pocetZubu = 0;
    			int pocetHracu = 0;
    			List<Mobile> mobs = new List<Mobile>( World.Mobiles.Values );
    			foreach ( Mobile m in mobs )
    			{
    				if ( m is PlayerMobile )
    				{
    					PlayerMobile pm = (PlayerMobile) m;
    					
                  if ( pm.Expy != null )
    					{
                      pocetZubu += pm.Expy;
                      pocetHracu++;
                      pm.Expy = 0;
    					}
    				}
    			}

    			from.SendMessage( 0x35, "{0} expu bylo smazano u {1} hracu.", pocetZubu, pocetHracu );
			}
		}
	}
}
