//This script adds the command [PurgeCreatures
//The command will delete all creatures that have been tamed and released
//The problem with creatures being released, is that the spawner respawns the creature
//and the released creature is left to roam, causing mobile build-up on your shard
//The script is also set to purge every time the shard go's through start-up
//To disable it running automatically, set the commented true to false
//Written by Kryptonite (AKA: Chief), inspired by KillerBeeZ 

using System;
using Server;
using System.Collections;
using Server.Mobiles;

namespace Server.Commands
{
	public class PurgeCreatures
	{
		public static void Initialize()
		{
			CommandSystem.Register( "SmazatPropustenePety", AccessLevel.Administrator, new CommandEventHandler( OnPurge ) );
			Server.EventSink.ServerStarted += new ServerStartedEventHandler(EventSink_ServerStarted);
		}

		[Usage( "SmazatPropustenePety" )]
		[Description( "Cleans up tamed and released Base Creatures" )]
		public static void OnPurge( CommandEventArgs e )
		{
			ArrayList bclist = new ArrayList();
			foreach( Mobile mob in World.Mobiles.Values )
			{
				if( mob is BaseCreature && mob.Map != Map.Internal )
				{
					BaseCreature bc = mob as BaseCreature;
					if( !bc.Controlled && bc.Owners != null && bc.Owners.Count > 0)
					{
						bclist.Add( bc );
					}
				}
			}
			int x = 0;
			foreach( Mobile item in bclist )
			{
				item.Delete();
				x++;
			}
			e.Mobile.SendMessage( x.ToString() + " propustenych petu bylo smazano" );
		}

		private static void EventSink_ServerStarted()
		{
			bool PurgeOnStart = true;  // change this to false if you do not want it to run automatically on start up

			if( PurgeOnStart )
			{
				ArrayList bclist = new ArrayList();
				foreach( Mobile mob in World.Mobiles.Values )
				{
					if( mob is BaseCreature && mob.Map != Map.Internal )
					{
						BaseCreature bc = mob as BaseCreature;
						if( !bc.Controlled && bc.Owners != null && bc.Owners.Count > 0)
						{
							bclist.Add( bc );
						}
					}
				}
				int x = 0;
				foreach( Mobile mob in bclist )
				{
					mob.Delete();
					x++;
				}
			}
		}
	}
}