using System;
using Server;
using Server.Gumps;
using Server.Network;
using Server.Multis;
using Server.Mobiles;
using System.Collections;
using System.Collections.Generic;
using Server.Engines.XmlSpawner2;

namespace Server.Items
{
    public class Test : Item, ISecurable
    {
        private SecureLevel m_Level;

        [CommandProperty(AccessLevel.GameMaster)]
        public SecureLevel Level
        {
            get { return m_Level; }
            set { m_Level = value; }
        }

        [Constructable]
        public Test() : base(4030)
        {
            Hue = 1161;
            Movable = true;
            Name = "Test Item";
            LootType = LootType.Blessed;
        }

        public Test(Serial serial) : base(serial)
        {
        }

        public override void OnDoubleClick(Mobile from)
        {
            SkeletalDragon.ItemSummoningRing(Utility.RandomMinMax(5,7), from, typeof(UnholyBone), 0, null, Utility.Random(0xECA, 9));

            //new TimerStateCallback(XmlSpecial.TriggerBanish), new object[] { from });

            //	SkillsBackupAttachment att = (SkillsBackupAttachment) XmlAttach.FindAttachment(from, typeof(SkillsBackupAttachment));
            ////CanBeginAction dodelat
            //	if (att != null)
            //	{
            //		from.SendMessage("att ne null");
            //		att.DoRestore();
            //	}
            //	else
            //	{
            //		from.SendMessage("att null");
            //		XmlAttach.AttachTo(from, new SkillsBackupAttachment());
            //		att = (SkillsBackupAttachment) XmlAttach.FindAttachment(from, typeof(SkillsBackupAttachment));

            //		if (att != null)
            //			att.DoBackup();
            //	}

            //          from.SendMessage( "IsSorcerers {0}, UnderColdBlood {1}", Server.Spells.SpellHelper.IsSorcerers( from.Map, from.Location ), Ability.UnderColdBlood( from ) );
        }

        public override void Serialize(GenericWriter writer)
        {
            base.Serialize(writer);

            writer.Write((int)1); // version

            writer.WriteEncodedInt((int)m_Level);
        }

        public override void Deserialize(GenericReader reader)
        {
            base.Deserialize(reader);

            int version = reader.ReadInt();

            switch (version)
            {
                case 1:
                    {
                        m_Level = (SecureLevel)reader.ReadEncodedInt();
                        goto case 0;
                    }

                case 0:
                    {
                        break;
                    }
            }
        }
    }
}