using System;
using Server;
using Server.Items;
using Server.Mobiles;
using Server.Targeting;
using Server.Gumps;

namespace Server.Commands
{
	public class Upalit
	{
		public static void Initialize()
		{
			CommandSystem.Register( "Upalit", AccessLevel.GameMaster, new CommandEventHandler( Upalit_OnCommand ) );
		}
		
		[Usage( "Upalit" )]
		[Description( "Posle hrace na hranici." )]
		private static void Upalit_OnCommand( CommandEventArgs e )
		{
			e.Mobile.Target = new UpalitTarget();
			e.Mobile.SendMessage( "Ktereho hrace chces poslat na hranici?" );
		}
		
		private class UpalitTarget : Target
		{
			public UpalitTarget() : base( -1, false, TargetFlags.None )
			{
			}

			protected override void OnTarget( Mobile from, object targeted )
			{
				if ( targeted is PlayerMobile )
				{
					PlayerMobile targ = (PlayerMobile)targeted;

					if ( from.AccessLevel <= targ.AccessLevel )
						from.SendMessage( "Nemas dostatecna prava poslat tohoto hrace na hrannici!" );
					if ( targ.NetState != null )
					{
						CommandLogging.WriteLine( from, "{0} {1} posila na hranici {2}", from.AccessLevel, CommandLogging.Format( from ), CommandLogging.Format( targeted ) );
						from.SendGump( new AdminGump( from, AdminGumpPage.ClientInfo, 0, null, null, targ ) );
						World.Broadcast( 37, true, "{0} je prave upalovan na hranici ve Vesperu", targ.Name );
						
						targ.Location = new Point3D( 2899, 697, 6 ); //souradnice
						targ.Map = Map.Trammel; //mapa
						targ.Direction = Direction.East;
						targ.Frozen = true;
						targ.ChatBan = true;
						targ.Squelched = true;
						targ.Blessed = true;
						//Dismount
						for ( int i = 0; i < targ.Items.Count; ++i )
						{
							Item item = targ.Items[i];
							
							if ( item is IMountItem )
							{
								IMount mount = ((IMountItem)item).Mount;
								
								if ( mount != null )
									mount.Rider = null;
								
								if ( targ.Items.IndexOf( item ) == -1 )
									--i;
							}
						}
						
						for ( int i = 0; i < targ.Items.Count; ++i )
						{
							Item item = targ.Items[i];
							
							if ( item.Layer == Layer.Mount )
							{
								item.Delete();
								--i;
							}
						}
						
						//Ohen
						//     					Effects.SendLocationEffect( new Point3D( 2898, 691, 0 ), Map.Trammel, Utility.RandomBool() ? 0x3E31 : 0x3E27, 3000 );
						SelfDeletingItem flame1 = new SelfDeletingItem( 14742, "ocistne plameny", 300 );
						flame1.MoveToWorld( new Point3D( 2901, 697, 0 ), Map.Trammel );
						SelfDeletingItem flame2 = new SelfDeletingItem( 14742, "ocistne plameny", 300 );
						flame2.MoveToWorld( new Point3D( 2901, 698, 0 ), Map.Trammel );
						SelfDeletingItem flame3 = new SelfDeletingItem( 14732, "ocistne plameny", 300 );
						flame3.MoveToWorld( new Point3D( 2900, 699, 0 ), Map.Trammel );
						SelfDeletingItem flame4 = new SelfDeletingItem( 14732, "ocistne plameny", 300 );
						flame4.MoveToWorld( new Point3D( 2899, 699, 0 ), Map.Trammel );

						//rajcata :)
						RottenTomato tomato1 = new RottenTomato();
						tomato1.MoveToWorld( new Point3D( 2903, 698, 0 ), Map.Trammel );
						RottenTomato tomato2 = new RottenTomato();
						tomato2.MoveToWorld( new Point3D( 2902, 695, 0 ), Map.Trammel );
						RottenTomato tomato3 = new RottenTomato();
						tomato3.MoveToWorld( new Point3D( 2896, 699, 0 ), Map.Trammel );
						RottenTomato tomato4 = new RottenTomato();
						tomato4.MoveToWorld( new Point3D( 2904, 696, 0 ), Map.Trammel );
					}
				}
			}
		}
	}
}
