using System;
using Server.Misc;
using Server.Gumps;
using Server.Mobiles;
using Server.Commands;
using Server.Targeting;

namespace Server.Commands
{
   public class UpdateTotalsCommand
   {
     public static void Initialize()
     {
  	      CommandSystem.Register( "opravitvahu", AccessLevel.GameMaster, new CommandEventHandler( UpdateTotals_OnCommand ) );
     }
  
     public static void Register( string command, AccessLevel access, CommandEventHandler handler )
     {
  	      CommandSystem.Register( command, access, handler );
     }
  
  	  [Usage( "opravitvahu" )] 
     [Description( "opravi vahu zamerenemu Mobile")] 
     public static void UpdateTotals_OnCommand( CommandEventArgs e )
     {
         e.Mobile.SendMessage( "Vyber hrace nebo NPC pro vyleceni" );
         e.Mobile.Target = new InternalTarget();
     }
     
		private class InternalTarget : Target
		{

			public InternalTarget() : base( 20, true, TargetFlags.None )
			{
			}

			protected override void OnTarget( Mobile from, object targeted )
			{
				if ( targeted is Mobile )
				{
			      ( targeted as Mobile ).UpdateTotals();
					from.SendMessage( "Hmotnost opravena ( Spustena funkce UpdateTotals() )" );
            }
            else
               from.SendMessage( "Musis vybrat hrace nebo NPC" );               
			}
		}
   }
}