/* Created by Hammerhand*/

using System;
using Server;
using Server.Items;
using Server.Mobiles;
using Server.Targeting;
using Server.Regions;
using Server.Engines.XmlSpawner2;

namespace Server.Engines.Harvest
{
	public class Archeology : HarvestSystem
	{
		private static Archeology m_System;
		
		public static Archeology System
		{
			get
			{
				if (m_System == null)
					m_System = new Archeology();

				return m_System;
			}
		}

		private HarvestDefinition m_Archeological;

		public HarvestDefinition Archeological
		{
			get { return m_Archeological; }
		}

		private Archeology()
		{
			HarvestResource[] res;
			HarvestVein[] veins;

			#region Archeological
			HarvestDefinition Archeological = m_Archeological = new HarvestDefinition();

			// Resource banks are every 6x6 tiles
			Archeological.BankWidth = 40;
			Archeological.BankHeight = 40;

			// Every bank holds from 10 to 15 rock
			Archeological.MinTotal = 1;
			Archeological.MaxTotal = 1;

			// A resource bank will respawn its content every 10 to 20 minutes
			Archeological.MinRespawn = TimeSpan.FromMinutes(45.0);
			Archeological.MaxRespawn = TimeSpan.FromMinutes(60.0);

			// Skill checking is done on the Forensics skill
			Archeological.Skill = SkillName.Forensics;

			// Set the list of harvestable tiles
			Archeological.Tiles = m_SandTiles;

			// Players must be within 2 tiles to harvest
			Archeological.MaxRange = 2;

			// One ore per harvest action
			Archeological.ConsumedPerHarvest = 1;
			Archeological.ConsumedPerFeluccaHarvest = 1;

			// The digging effect
			Archeological.EffectActions = new int[] { 9, 10, 11, 12, 13, 30, 31, 32 };
			Archeological.EffectSounds = new int[] { 0x125, 0x126, 826, 827, 828, 831, 832, 833, 834 };
			Archeological.EffectCounts = new int[] { 5, 7, 8, 9, 10, 12 };
			Archeological.EffectDelay = TimeSpan.FromSeconds( 1.6 );
			Archeological.EffectSoundDelay = TimeSpan.FromSeconds( 0.9 );

			Archeological.NoResourcesMessage = "Jiz zde nejsou zadne artefakty k nalezeni"; // There is no metal here to mine.
			Archeological.DoubleHarvestMessage = "Nekdo zde nasel artefakt chvili pred tebou"; // Someone has gotten to the metal before you.
			Archeological.TimedOutOfRangeMessage = 500446; //  That is too far away.
			Archeological.OutOfRangeMessage = 500446; // That is too far away.
			Archeological.FailMessage = "Po chvili hledani se ti nepodarilo najit zadny artefakt"; // You loosen some rocks but fail to find any useable ore.
			Archeological.PackFullMessage = "Your backpack can't hold the artifact, and it is lost!"; // Your backpack is full, so the ore you mined is lost.
			Archeological.ToolBrokeMessage = 1044038; // You have worn out your tool!

			res = new HarvestResource[]
			{
				new HarvestResource( 59.0, 59.0, 150.0, "You find an artifact fragment and put it in your backpack", typeof (ArtifactFragment) )
			};

			veins = new HarvestVein[]
			{
				new HarvestVein( 100.0, 0.0, res[0], null )
			};

			Archeological.Resources = res;
			Archeological.Veins = veins;

			Definitions.Add(Archeological);
			#endregion
		}

		/*public override bool CheckHarvest(Mobile from, Item tool, HarvestDefinition def, object toHarvest)
		{
			if (!base.CheckHarvest(from, tool, def, toHarvest))
				return false;

			if (def == m_Archeological && !(from is PlayerMobile && from.Skills[SkillName.Forensics].Base >= 60.0 && from.Skills[SkillName.Mining].Base >= 110.0 && Server.Engines.XmlSpawner2.XmlAttach.FindAttachment( from, typeof( Archeology ) ) != null ))
			{
				OnBadHarvestTarget(from, tool, toHarvest);
				return false;
			}
			else if (from.Mounted)
			{
				from.SendLocalizedMessage(501864); // You can't mine while riding.
				return false;
			}
			else if (from.IsBodyMod && !from.Body.IsHuman)
			{
				from.SendLocalizedMessage(501865); // You can't mine while polymorphed.
				return false;
			}

			return true;
		}*/

		public override bool Give( Mobile m, Item item, bool placeAtFeet )
		{
         Engines.XmlSpawner2.Archeology att = (Engines.XmlSpawner2.Archeology)XmlAttach.FindAttachment( m, typeof(Engines.XmlSpawner2.Archeology) );
         
         if ( Utility.RandomDouble() < 0.6 )
         {
            item.Delete();
           
           if ( ( 0.05 + ((m.Skills[SkillName.Forensics].Value - 75.0) / (190.0 - 75.0) * (1.0 - 0.05)) - 0.05 ) * 0.05 > Utility.RandomDouble() )
           {
              if ( KhaldunRevenant.IsInsideKhaldun( m ) )
                  m.AddToBackpack( (Item)Activator.CreateInstance( Teragon.KhaldunArtifacts[Utility.Random(Teragon.KhaldunArtifacts.Length)] ) );
               else
                  m.AddToBackpack( (Item)Activator.CreateInstance( Teragon.Artifacts[Utility.Random(Teragon.Artifacts.Length)] ) );
              
              m.PlaySound( 0x3D );
              Guilds.Guild.GiveXp( m, 15000 );
              World.Broadcast( 37, true, "Archeolog {0} prave {1} artefakt!", m.RawName, m.Female ? "nasla" : "nasel" );
              
              if ( att != null ) att.Artifacts++;
              
              return false;
           }
           else if ( Utility.RandomDouble() < 0.2 )
           {
              Graverobber rob = new Graverobber();
              rob.PackItem( (Item)Activator.CreateInstance( ASoullessBlade.ExtraLoot[Utility.Random(ASoullessBlade.ExtraLoot.Length)] ) );
              
               if ( Teragon.CheckConvert( rob, m.Location, m.Map ) )
                  rob.IsTeragon = true;
              
              rob.Fame = 8000;
              rob.MoveToWorld( TavaraSewel.GetSpawnPosition( m.Location, m.Map, 4 ), m.Map );
              rob.Say( Graverobber.GraverobberSay[ Utility.Random( Graverobber.GraverobberSay.Length ) ] );
              rob.Combatant = m;
              rob.PlaySound( rob.Female ? 796 : 1068 );
              
              if ( att != null ) att.Graverobbers++;
              
            if ( att.Graverobbers > 99 )
				  PlayerTitles.AddTitle( m, 27 );
              
              return false;
           }
           
            m_Archeological.SendMessageTo( m, m_Archeological.FailMessage );
            return false;
         }        
         else
         {
            if ( att != null ) att.Fragments++;
            
            if ( att.Fragments > 199 )
				  PlayerTitles.AddTitle( m, 28 );
              
            return base.Give( m, item, placeAtFeet );
         }
      }

		public override bool BeginHarvesting(Mobile from, Item tool)
		{
			if ( XmlAttach.FindAttachment( from, typeof( Engines.XmlSpawner2.Archeology ) ) == null )
			{
				from.SendMessage("Musis si napred precist knihu o archeologii");
				return false;
			}
			if ( KhaldunRevenant.IsInsideKhaldun( from ) || from.Region.IsPartOf( typeof( Server.Regions.FireRegion ) ) )
			{
				return !base.BeginHarvesting(from, tool);
			}
			else
			{
				from.SendMessage("Na tomto miste nelze hledat artefakty");
				return false;
			}
		}
		
		public override void OnHarvestStarted(Mobile from, Item tool, HarvestDefinition def, object toHarvest)
		{
			base.OnHarvestStarted(from, tool, def, toHarvest);
		}
		
		public override void OnBadHarvestTarget(Mobile from, Item tool, object toHarvest)
		{
			if (toHarvest is LandTarget)
				from.SendMessage("Zde nelze hledat artefakty"); // You can't mine there.
			else
				from.SendLocalizedMessage(501863); // You can't mine that.
		}
		
		public static void Initialize()
		{
			Array.Sort(m_SandTiles);
		}
		
		#region Tile lists
		private static int[] m_SandTiles = new int[]
		{
			22, 23, 24, 25, 26, 27, 28, 29, 30, 31,
			32, 33, 34, 35, 36, 37, 38, 39, 40, 41,
			42, 43, 44, 45, 46, 47, 48, 49, 50, 51,
			52, 53, 54, 55, 56, 57, 58, 59, 60, 61,
			62, 68, 69, 70, 71, 72, 73, 74, 75,

			298, 299, 300, 301, 402, 424, 425, 426,
			427, 441, 442, 443, 444, 445, 446, 447, 448, 449,
			450, 451, 452, 453, 454, 455, 456, 457, 458, 459,
			460, 461, 462, 463, 464, 465, 642, 643, 644, 645,
			650, 651, 652, 653, 654, 655, 656, 657, 821, 822,
			823, 824, 825, 826, 827, 828, 833, 834, 835, 836,
			845, 846, 847, 848, 849, 850, 851, 852, 857, 858,
			859, 860, 951, 952, 953, 954, 955, 956, 957, 958,
			967, 968, 969, 970,

			1447, 1448, 1449, 1450, 1451, 1452, 1453, 1454, 1455,
			1456, 1457, 1458, 1611, 1612, 1613, 1614, 1615, 1616,
			1617, 1618, 1623, 1624, 1625, 1626, 1635, 1636, 1637,
			1638, 1639, 1640, 1641, 1642, 1647, 1648, 1649, 1650,
			
			//mining
			220, 221, 222, 223, 224, 225, 226, 227, 228, 229,
			230, 231, 236, 237, 238, 239, 240, 241, 242, 243,
			244, 245, 246, 247, 252, 253, 254, 255, 256, 257,
			258, 259, 260, 261, 262, 263, 268, 269, 270, 271,
			272, 273, 274, 275, 276, 277, 278, 279, 286, 287,
			288, 289, 290, 291, 292, 293, 294, 296, 296, 297,
			321, 322, 323, 324, 467, 468, 469, 470, 471, 472,
			473, 474, 476, 477, 478, 479, 480, 481, 482, 483,
			484, 485, 486, 487, 492, 493, 494, 495, 543, 544,
			545, 546, 547, 548, 549, 550, 551, 552, 553, 554,
			555, 556, 557, 558, 559, 560, 561, 562, 563, 564,
			565, 566, 567, 568, 569, 570, 571, 572, 573, 574,
			575, 576, 577, 578, 579, 581, 582, 583, 584, 585,
			586, 587, 588, 589, 590, 591, 592, 593, 594, 595,
			596, 597, 598, 599, 600, 601, 610, 611, 612, 613,

			1010, 1741, 1742, 1743, 1744, 1745, 1746, 1747, 1748, 1749,
			1750, 1751, 1752, 1753, 1754, 1755, 1756, 1757, 1771, 1772,
			1773, 1774, 1775, 1776, 1777, 1778, 1779, 1780, 1781, 1782,
			1783, 1784, 1785, 1786, 1787, 1788, 1789, 1790, 1801, 1802,
			1803, 1804, 1805, 1806, 1807, 1808, 1809, 1811, 1812, 1813,
			1814, 1815, 1816, 1817, 1818, 1819, 1820, 1821, 1822, 1823,
			1824, 1831, 1832, 1833, 1834, 1835, 1836, 1837, 1838, 1839,
			1840, 1841, 1842, 1843, 1844, 1845, 1846, 1847, 1848, 1849,
			1850, 1851, 1852, 1853, 1854, 1861, 1862, 1863, 1864, 1865,
			1866, 1867, 1868, 1869, 1870, 1871, 1872, 1873, 1874, 1875,
			1876, 1877, 1878, 1879, 1880, 1881, 1882, 1883, 1884, 1981,
			1982, 1983, 1984, 1985, 1986, 1987, 1988, 1989, 1990, 1991,
			1992, 1993, 1994, 1995, 1996, 1997, 1998, 1999, 2000, 2001,
			2002, 2003, 2004, 2028, 2029, 2030, 2031, 2032, 2033, 2100,
			2101, 2102, 2103, 2104, 2105/*,

				0x453B, 0x453C, 0x453D, 0x453E, 0x453F, 0x4540, 0x4541,
				0x4542, 0x4543, 0x4544,	0x4545, 0x4546, 0x4547, 0x4548,
				0x4549, 0x454A, 0x454B, 0x454C, 0x454D, 0x454E,	0x454F*/
		};
		#endregion
	}
}
