// LootData.cs
// Author: Oak (ssalter)
// Version: 1.0
// Requirements: Runuo 2.0, XmlSpawner2
// Server Tested with: 2.0 build 64
// Revision Date: 7/1/2006
// Purpose: Player can type 'grab options' to get a gump and select what types of items they want to transfer
// to their lootbag when using the 'claim' command. Uses XMLAttachment for loot options

using System;
using Server;
using Server.Items;
using Server.Network;
using Server.Mobiles;

namespace Server.Engines.XmlSpawner2
{
	public class Archeology : XmlAttachment
	{
		private int m_Fragments, m_Counter1, m_Artifacts, m_Graverobbers;

		[CommandProperty( AccessLevel.GameMaster )]
		public int Fragments { get { return m_Fragments; } set { m_Fragments  = value; } }
		
		[CommandProperty( AccessLevel.GameMaster )]
		public int Counter1 { get { return m_Counter1; } set { m_Counter1  = value; } }

		[CommandProperty( AccessLevel.GameMaster )]
		public int Artifacts { get { return m_Artifacts; } set { m_Artifacts  = value; } }
		
		[CommandProperty( AccessLevel.GameMaster )]
		public int Graverobbers { get { return m_Graverobbers; } set { m_Graverobbers  = value; } }

		public Archeology(ASerial serial) : base(serial)
		{
		}

		[Attachable]
		public Archeology()
		{
         Name = "Archeology";
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize(writer);

			writer.Write( (int) 0 );
			// version 0

			writer.Write(m_Fragments);
			writer.Write(m_Counter1);
			writer.Write(m_Artifacts);
			writer.Write(m_Graverobbers);
		}

		public override void Deserialize(GenericReader reader)
		{
			base.Deserialize(reader);
			// version 0
			int version = reader.ReadInt();

			m_Fragments = reader.ReadInt();
			m_Counter1 = reader.ReadInt();
			m_Artifacts = reader.ReadInt();
			m_Graverobbers = reader.ReadInt();
		}
	}
}
