using System;
using Server.Items;
using Server.Mobiles;
using Server.Engines.XmlSpawner2;

namespace Server.Items
{
	public class ArcheologyBook : Item
	{
		[Constructable]
		public ArcheologyBook() : base( 0xFF4 )
		{
			Name = "Archeologie od A do Z";
			Weight = 1.0;
			Hue = 0;
		}

		public ArcheologyBook(Serial serial)
			: base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}

		public override void OnDoubleClick( Mobile from )
		{
			PlayerMobile pm = from as PlayerMobile;

			if ( !IsChildOf( from.Backpack ) )
			{
				from.SendLocalizedMessage( 1042001 ); // That must be in your pack for you to use it.
			}
			else if ( pm == null || from.Skills[SkillName.Forensics].Base < 60.0 || from.Skills[SkillName.Mining].Base < 110.0 )
			{
				pm.SendMessage( "Skilly potrebne pro nauceni archeologie: 60 Forensics, 110 mining" );
			}
			else if ( XmlAttach.FindAttachment( pm, typeof( Archeology ) ) != null )
			{
				pm.SendMessage( "Tuto knihu jiz mas prectenou" );
			}
			else
			{
				XmlAttach.AttachTo( pm, new Archeology() );
				pm.PlaySound( 585 );
				pm.PlaySound( 85 );
				pm.SendMessage("Nyni muzes hledat artefakty v dungeonech Fire a Khaldun (Felucca)");
				Delete();
			}
		}
	}
}
