using System;

namespace Server.Items
{
	public class ArtifactFragment : Item
	{
		[Constructable]
		public ArtifactFragment() : this( 1 )
		{
		}

		[Constructable]
		public ArtifactFragment( int amount ) : base( 2428 )
		{
			Weight = 0.2;
			Stackable = true;
			Amount = amount;
			Name = "artifact fragment";
			Hue = 2530;
		}

		public ArtifactFragment( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}