using System;
using Server;
using Server.Network;
using Server.Targeting;

namespace Server.Items
{
	public class BaseCharm : Item
	{
		private int m_Charges;
		
		public virtual Type GetRechargeType() { return typeof( ArtifactFragment ); }
		
		[CommandProperty( AccessLevel.GameMaster )]
		public int Charges
		{
			get{ return m_Charges; }
			set
			{
				if ( value > 5000000 )
					m_Charges = 5000000;
				else if ( value < 0 )
					m_Charges = 0;
				else
					m_Charges = value;

				InvalidateProperties();
			}
		}
		
		public BaseCharm( int itemID ) : base( itemID )
		{
			Weight = 1.0;
			Hue = 0;
			Name = "charm";
			Charges = 0;
			LootType = LootType.Blessed;
		}
		
		public override void GetProperties( ObjectPropertyList list )
		{
			base.GetProperties( list );

			list.Add( 1060741, m_Charges.ToString() ); // charges: ~1_val~
		}
		
		public override void OnDoubleClick( Mobile from )
		{
         if ( this.IsChildOf( from.Backpack ) )
			{
				if ( this is BaseTotemSummoner )
				{
               ((BaseTotemSummoner)this).DClickAction( from );
            }
            else
            {
				  from.SendMessage( "Zamer {0} pro dobiti {1}", this.GetRechargeType().Name, this.Name );
				  from.Target = new InternalTarget( this );
				  
              if ( this.BlessedFor == null )
				     from.SendMessage( 34, "POZOR, {0} bude linknut na tebe", this.Name );
            }
			}
			else
			{
				from.SendLocalizedMessage( 1042001 ); // That must be in your pack for you to use it.
			}
		}

		private class InternalTarget : Target
		{
			private BaseCharm m_Charm;

			public InternalTarget( BaseCharm charm ) : base( -1, false, TargetFlags.None )
			{
				m_Charm = charm;
			}

			protected override void OnTarget( Mobile from, object targeted )
			{
				if ( m_Charm == null || m_Charm.Deleted )
					return;

				if ( !from.InRange( m_Charm.GetWorldLocation(), 2 ) )
				{
					from.LocalOverheadMessage( MessageType.Regular, 0x3B2, 1019045 ); // I can't reach that.
				}
				else if ( targeted.GetType() == m_Charm.GetRechargeType() )
				{
					Item rechargeItem = (Item)targeted;
               
               m_Charm.Charges += rechargeItem.Amount;
               from.SendMessage( "{0} pouziti bylo pridano do {1}", rechargeItem.Amount, m_Charm.Name );
               rechargeItem.Delete();
               m_Charm.BlessedFor = from;
				}
				else
				{
					from.SendMessage( "Musis zamerit {0}", m_Charm.GetRechargeType().Name );
				}
			}
		}

		public BaseCharm( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.WriteEncodedInt( (int) 0 ); // version

			writer.WriteEncodedInt( (int) m_Charges );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadEncodedInt();

			switch ( version )
			{
				case 1:
					{
						goto case 0;
					}
				case 0:
					{
						m_Charges = Math.Min( reader.ReadEncodedInt(), 5000000 );
						break;
					}
			}
		}
	}
}
