using System;

namespace Server.Items
{
	public class CharmOfColdSnap : BaseCharm
	{
      [Constructable]
		public CharmOfColdSnap() : base( 13944 )
		{
			Weight = 4.0;
			Name = "charm of cold snap";
		}
		
		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			
			list.Add( "<basefont color=#9999FF>If charm is hold in backpack\nCold damage from your weapon\nhas chance to freeze target<basefont color=White>" );
		}

		public CharmOfColdSnap( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}