using System;

namespace Server.Items
{
	public class CharmOfCorpseExplosion : BaseCharm
	{
		[Constructable]
		public CharmOfCorpseExplosion() : base( 13945 )
		{
			Weight = 1.0;
			Name = "charm of corpse explosion";
		}
		
		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			
			list.Add( "<basefont color=#9999FF>If charm is hold in backpack\nExplosion spell explodes up to\n3 corpses around target\nfor 15-30% of the corpse's maximum Life<basefont color=White>" );
		}

		public CharmOfCorpseExplosion( Serial serial ) : base( serial )
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );
			writer.Write( (int) 0 );
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );
			int version = reader.ReadInt();
		}
	}
}